/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import org.apache.tools.analyzer.CodeBlock;
import org.apache.tools.analyzer.Decompiler;
import org.apache.tools.analyzer.DecompilerException;
import org.apache.tools.analyzer.ExpandableArray;
import org.apache.tools.analyzer.UniqueVector;

public class TargetSet {
    public int targetLocation;
    public CodeBlock caseBlock;
    public boolean isDefault = false;
    public ExpandableArray values = new ExpandableArray();
    public int smallestValue;

    public TargetSet(int n, int n2) {
        this.targetLocation = n;
        this.addValue(n2);
    }

    public void addValue(int n) {
        this.values.add(n);
        if (this.values.size() == 1) {
            this.smallestValue = n;
        } else if (n < this.smallestValue) {
            this.smallestValue = n;
        }
    }

    public TargetSet getNextTargetSet(UniqueVector uniqueVector) throws DecompilerException {
        TargetSet targetSet = null;
        if (this.caseBlock == null) {
            return null;
        }
        int n = 0;
        while (n < uniqueVector.size()) {
            TargetSet targetSet2 = (TargetSet)uniqueVector.elementAt(n);
            if (targetSet2 != this && targetSet2.caseBlock != null && this.caseBlock.nextBlockList.contains(targetSet2.caseBlock)) {
                if (targetSet != null) {
                    Decompiler.report("Invalid ordering of case blocks in switch");
                } else {
                    targetSet = targetSet2;
                }
            }
            ++n;
        }
        return targetSet;
    }

    public int getNextValueAbove(int n) {
        int n2 = n;
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.values.size()) {
            if (this.values.get(n3) > n) {
                if (!bl) {
                    n2 = this.values.get(n3);
                    bl = true;
                } else if (this.values.get(n3) < n2) {
                    n2 = this.values.get(n3);
                }
            }
            ++n3;
        }
        if (!bl) {
            return n;
        }
        return n2;
    }

    public String valuesString() {
        String string = "";
        int n = 0;
        while (n < this.values.size()) {
            string = String.valueOf(string) + " " + this.values.get(n);
            ++n;
        }
        return string;
    }
}

