/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer.info;

import java.io.IOException;
import java.util.Vector;
import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.ClassFileInputStream;
import org.apache.tools.analyzer.ClassLoad;
import org.apache.tools.analyzer.ConstantPool;
import org.apache.tools.analyzer.Decompiler;
import org.apache.tools.analyzer.HashedVector;
import org.apache.tools.analyzer.IStatusListener;
import org.apache.tools.analyzer.NameMgr;
import org.apache.tools.analyzer.UniqueVector;
import org.apache.tools.analyzer.info.AttributeEntry;
import org.apache.tools.analyzer.info.FieldInfo;
import org.apache.tools.analyzer.info.MethodInfo;
import org.apache.tools.analyzer.info.UnitInfo;

public class ClassInfo
extends UnitInfo {
    private static final int LOCAL = 1;
    private static final int EXTERNAL = 2;
    private static final boolean debug = false;
    private static ClassFileInputStream dataReader = null;
    private AttributeEntry[] attributes;
    private ConstantPool constantPool;
    private String[] interfaces;
    public HashedVector classInformation;
    private String superClassName;
    private int accessFlags;
    private ClassLoad loader;
    private boolean loadReferenced;
    public String fullFileName;
    public String sourceFileName = null;
    public HashedVector classMethods = new HashedVector();
    public HashedVector classFields = new HashedVector();
    public HashedVector classesThatRefMe = new HashedVector();
    public HashedVector classesIRef = new HashedVector();
    public HashedVector classesThatExtendOrImplementMe = new HashedVector();
    public HashedVector predecessors = null;
    public HashedVector interfacesIExtendOrImplement = new HashedVector();
    public HashedVector methodsThatCreateMe = new HashedVector();
    public HashedVector fieldsOfMyType = new HashedVector();
    private boolean limit;
    private boolean warning;
    private UniqueVector typelist = null;
    private int depth;

    private ClassInfo(String string, int n) {
        this.rawName = string;
        this.superClassName = "Unknown";
        this.loaded = false;
        this.interfaces = new String[0];
    }

    public ClassInfo(HashedVector hashedVector, String string, ClassFileInputStream classFileInputStream, ClassLoad classLoad, boolean bl) {
        this.classInformation = hashedVector;
        this.loader = classLoad;
        dataReader = classFileInputStream;
        this.loadReferenced = bl;
        this.fullFileName = string;
    }

    private boolean addInterfacesThatIImplement(ClassInfo classInfo) {
        ++this.depth;
        if (this.depth > 100) {
            AnalyzerUtilities.alert("Interface circularity error");
            --this.depth;
            return false;
        }
        int n = 0;
        while (n < classInfo.interfaces.length) {
            String string = classInfo.interfaces[n];
            ClassInfo classInfo2 = (ClassInfo)this.classInformation.get(string);
            if (classInfo2 == null) {
                AnalyzerUtilities.alert("Implemented Interface Not Found = " + string);
            } else {
                this.interfacesIExtendOrImplement.add(classInfo2, true);
                classInfo2.classesThatExtendOrImplementMe.add(this, true);
                if (!this.addInterfacesThatIImplement(classInfo2)) {
                    --this.depth;
                    return false;
                }
            }
            ++n;
        }
        --this.depth;
        return true;
    }

    private ClassInfo addNonLoadedClassEntry(String string, HashedVector hashedVector) {
        ClassInfo classInfo = new ClassInfo(string, hashedVector.size());
        classInfo.classInformation = hashedVector;
        hashedVector.add(classInfo, true);
        return classInfo;
    }

    public void addReferencedClasses() {
        UniqueVector uniqueVector = this.buildVectorOfReferencedTypes();
        int n = 0;
        while (n < uniqueVector.size()) {
            this.assureClassEntry((String)uniqueVector.elementAt(n));
            ++n;
        }
    }

    public HashedVector allMyPredecessors() {
        if (this.predecessors != null) {
            return this.predecessors;
        }
        HashedVector hashedVector = new HashedVector();
        ClassInfo classInfo = this;
        while (true) {
            hashedVector.add(classInfo.getInterfaceTree(new HashedVector()), true);
            classInfo = classInfo.getSuperClass();
            if (classInfo == null) break;
            hashedVector.add(classInfo, true);
        }
        this.predecessors = hashedVector;
        return hashedVector;
    }

    private static void appendVector(UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        int n = 0;
        while (n < uniqueVector2.size()) {
            uniqueVector.addElement(uniqueVector2.elementAt(n));
            ++n;
        }
    }

    private void assureClassEntry(String string) {
        Object object;
        if (string.charAt(0) == '[') {
            object = AnalyzerUtilities.getReferredClassType(string);
            if (object == null) {
                return;
            }
            string = object;
        }
        if ((object = (ClassInfo)this.classInformation.get(string)) == null) {
            object = this.addNonLoadedClassEntry(string, this.classInformation);
        }
        this.classesIRef.add((UnitInfo)object, true);
        ((ClassInfo)object).classesThatRefMe.add(this, true);
    }

    private void attemptLoadReferenced() {
        UniqueVector uniqueVector = this.buildVectorOfReferencedTypes();
        int n = 0;
        while (n < uniqueVector.size()) {
            block7: {
                Object object;
                String string;
                block6: {
                    string = (String)uniqueVector.elementAt(n);
                    if (string.charAt(0) != '[') break block6;
                    object = AnalyzerUtilities.getReferredClassType(string);
                    if (object == null) break block7;
                    string = object;
                }
                object = (ClassInfo)this.classInformation.get(string);
                if (this.rawName.equals(string) && object == null) {
                    AnalyzerUtilities.p("attemptLoadReferenced: Internal Error");
                }
                if (object == null && !this.loader.loadClassByName(string)) {
                    this.addNonLoadedClassEntry(string, this.classInformation);
                }
            }
            ++n;
        }
    }

    private UniqueVector buildVectorOfReferencedTypes() {
        String string;
        int n;
        if (this.typelist != null) {
            return this.typelist;
        }
        this.typelist = new UniqueVector();
        if (this.constantPool != null) {
            n = 1;
            while (n < this.constantPool.constant_tag.length) {
                if (this.constantPool.constant_tag[n] == 7) {
                    String string2 = this.readConstantPoolEntryString(n);
                    this.typelist.addUnique(string2);
                }
                ++n;
            }
            int n2 = 1;
            while (n2 < this.constantPool.constant_tag.length) {
                if (this.constantPool.constant_tag[n2] == 12) {
                    string = this.readConstantPoolEntryString(n2);
                    UniqueVector uniqueVector = AnalyzerUtilities.extractTypes(string);
                    int n3 = 0;
                    while (n3 < uniqueVector.size()) {
                        this.typelist.addUnique((String)uniqueVector.elementAt(n3));
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        n = 0;
        while (n < this.classMethods.size()) {
            UniqueVector uniqueVector = ((MethodInfo)this.classMethods.get(n)).myClassTypeNames();
            int n4 = 0;
            while (n4 < uniqueVector.size()) {
                this.typelist.addUnique((String)uniqueVector.elementAt(n4));
                ++n4;
            }
            ++n;
        }
        int n5 = 0;
        while (n5 < this.classFields.size()) {
            string = ((FieldInfo)this.classFields.get(n5)).myClassTypeName();
            if (string != null) {
                this.typelist.addUnique(string);
            }
            ++n5;
        }
        return this.typelist;
    }

    public String classType() {
        String string = this.loaded ? (this.isInterface() ? "Inteface " : "Class ") : "";
        return string;
    }

    public boolean containFieldNamed(String string) {
        int n = 0;
        while (n < this.classFields.size()) {
            FieldInfo fieldInfo = (FieldInfo)this.classFields.get(n);
            if (fieldInfo.getFieldOnlyName().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public UniqueVector decompile(IStatusListener iStatusListener, boolean bl, boolean bl2, boolean bl3) {
        if (!this.loaded) {
            return null;
        }
        this.warning = false;
        this.limit = false;
        Decompiler.initSymbols();
        NameMgr.initialize(bl2, bl3);
        UniqueVector uniqueVector = this.getHeader();
        UniqueVector uniqueVector2 = this.getMethodDefs(iStatusListener, bl);
        UniqueVector uniqueVector3 = this.getFieldDefs();
        UniqueVector uniqueVector4 = this.getPreliminary();
        UniqueVector uniqueVector5 = this.getMessages();
        UniqueVector uniqueVector6 = new UniqueVector();
        ClassInfo.appendVector(uniqueVector6, uniqueVector5);
        ClassInfo.appendVector(uniqueVector6, uniqueVector4);
        ClassInfo.appendVector(uniqueVector6, uniqueVector);
        ClassInfo.appendVector(uniqueVector6, uniqueVector3);
        ClassInfo.appendVector(uniqueVector6, uniqueVector2);
        uniqueVector6.addElement("}");
        return uniqueVector6;
    }

    public String getClassOnlyDisplayName() {
        return AnalyzerUtilities.classOnlyName(this.rawName);
    }

    public String getCompleteDisplayName() {
        return this.rawName;
    }

    public Object getConstant(int n) {
        if (this.constantPool != null) {
            return this.constantPool.readConstantPoolEntry(n);
        }
        return null;
    }

    public String getConstantName(int n) {
        if (this.constantPool != null) {
            return this.constantPool.getConstantName(n);
        }
        return null;
    }

    private UniqueVector getFieldDefs() {
        UniqueVector uniqueVector = new UniqueVector();
        UniqueVector uniqueVector2 = this.getSortedFields(true);
        int n = 0;
        while (n < uniqueVector2.size()) {
            FieldInfo fieldInfo = (FieldInfo)uniqueVector2.elementAt(n);
            String string = !fieldInfo.isFinal() ? "" : "   // final";
            String string2 = NameMgr.useConvert(fieldInfo.myTypeName(), 1);
            String string3 = Decompiler.findInitSymbol(fieldInfo);
            String string4 = string3 == null && this.isInterface() ? "// " : "";
            string3 = string3 == null ? "" : " = " + string3;
            uniqueVector.addElement(String.valueOf(string4) + fieldInfo.getStatusesExFinal() + string2 + " " + fieldInfo.getFieldOnlyName() + string3 + ";" + string);
            ++n;
        }
        if (uniqueVector2.size() > 0) {
            uniqueVector.addElement("");
        }
        return uniqueVector;
    }

    private UniqueVector getHeader() {
        String string;
        UniqueVector uniqueVector = new UniqueVector();
        String string2 = NameMgr.useConvert(this.getCompleteDisplayName(), 1);
        if (this.isInterface()) {
            string = String.valueOf(this.getStatusesExcAbstract()) + "interface " + string2;
            if (this.interfaces.length > 0) {
                string = String.valueOf(string) + " extends ";
                int n = 0;
                while (n < this.interfaces.length) {
                    if (n > 0) {
                        string = String.valueOf(string) + ", ";
                    }
                    string = String.valueOf(string) + NameMgr.useConvert(this.interfaces[n], 1);
                    ++n;
                }
            }
        } else {
            string = String.valueOf(this.getStatuses()) + "class " + string2;
            if (this.superClassName != null) {
                string = String.valueOf(string) + " extends " + NameMgr.useConvert(this.superClassName, 1);
            }
            if (this.interfaces.length > 0) {
                string = String.valueOf(string) + " implements ";
                int n = 0;
                while (n < this.interfaces.length) {
                    if (n > 0) {
                        string = String.valueOf(string) + ", ";
                    }
                    string = String.valueOf(string) + NameMgr.useConvert(this.interfaces[n], 1);
                    ++n;
                }
            }
        }
        uniqueVector.addElement(string);
        uniqueVector.addElement("");
        uniqueVector.addElement("{");
        uniqueVector.addElement("");
        return uniqueVector;
    }

    public HashedVector getInterfaceTree(HashedVector hashedVector) {
        hashedVector.add(this.interfacesIExtendOrImplement, true);
        int n = 0;
        while (n < this.interfacesIExtendOrImplement.size()) {
            ClassInfo classInfo = (ClassInfo)this.interfacesIExtendOrImplement.get(n);
            hashedVector.add(classInfo.getInterfaceTree(hashedVector), true);
            ++n;
        }
        return hashedVector;
    }

    private UniqueVector getMessages() {
        UniqueVector uniqueVector = new UniqueVector();
        if (this.warning) {
            uniqueVector.addElement("Some warnings were generated - please see method decompilation for details");
        }
        if (uniqueVector.size() > 0) {
            uniqueVector.addElement("");
        }
        return uniqueVector;
    }

    private UniqueVector getMethodDefs(IStatusListener iStatusListener, boolean bl) {
        Object object;
        UniqueVector uniqueVector = new UniqueVector();
        UniqueVector uniqueVector2 = new UniqueVector();
        UniqueVector uniqueVector3 = new UniqueVector();
        int n = 0;
        while (n < this.classMethods.size()) {
            object = (MethodInfo)this.classMethods.get(n);
            uniqueVector.addElement(((MethodInfo)object).getMethodOnlyName());
            uniqueVector2.addElement(object);
            ++n;
        }
        object = AnalyzerUtilities.sort(uniqueVector, uniqueVector2)[1];
        int n2 = 0;
        while (n2 < ((Vector)object).size()) {
            MethodInfo methodInfo = (MethodInfo)((Vector)object).elementAt(n2);
            UniqueVector uniqueVector4 = methodInfo.decompile(iStatusListener, bl);
            if (Decompiler.messages.size() > 0) {
                this.warning = true;
            }
            int n3 = 0;
            while (n3 < uniqueVector4.size()) {
                uniqueVector3.addElement(uniqueVector4.elementAt(n3));
                ++n3;
            }
            ++n2;
        }
        return uniqueVector3;
    }

    private UniqueVector getPreliminary() {
        UniqueVector uniqueVector = new UniqueVector();
        String string = this.getRawPackageName();
        if (string != null) {
            string = string.substring(0, string.length() - 1);
            string = AnalyzerUtilities.makeSourceNameFromJavaName(string);
            uniqueVector.addElement("package " + string + ";");
            uniqueVector.addElement("");
        }
        UniqueVector uniqueVector2 = NameMgr.getImports();
        int n = 0;
        while (n < uniqueVector2.size()) {
            uniqueVector.addElement("import " + uniqueVector2.elementAt(n) + "*;");
            ++n;
        }
        if (uniqueVector.size() > 0) {
            uniqueVector.addElement("");
        }
        return uniqueVector;
    }

    public String getRawPackageName() {
        int n = this.rawName.lastIndexOf("/");
        if (n < 0) {
            return null;
        }
        return this.rawName.substring(0, n + 1);
    }

    public UniqueVector getSortedFields(boolean bl) {
        Object object;
        UniqueVector uniqueVector = new UniqueVector();
        UniqueVector uniqueVector2 = new UniqueVector();
        int n = 0;
        while (n < this.classFields.size()) {
            object = (FieldInfo)this.classFields.get(n);
            uniqueVector.addElement(((FieldInfo)object).getFieldOnlyName());
            uniqueVector2.addElement(object);
            ++n;
        }
        object = AnalyzerUtilities.sort(uniqueVector, uniqueVector2);
        if (bl) {
            return object[1];
        }
        return object[0];
    }

    public String getSourceFileName() {
        if (this.sourceFileName != null) {
            return this.sourceFileName;
        }
        return String.valueOf(AnalyzerUtilities.removeExtension(this.fullFileName)) + ".java";
    }

    public String getStatuses() {
        if (!this.loaded) {
            return "";
        }
        String string = "";
        if (this.isPublic()) {
            string = "public ";
        }
        if (this.isAbstract()) {
            string = String.valueOf(string) + "abstract ";
        }
        if (this.isFinal()) {
            string = String.valueOf(string) + "final ";
        }
        return string;
    }

    public String getStatusesExcAbstract() {
        if (!this.loaded) {
            return "";
        }
        String string = "";
        if (this.isPublic()) {
            string = "public ";
        }
        if (this.isFinal()) {
            string = String.valueOf(string) + "final ";
        }
        return string;
    }

    public ClassInfo getSuperClass() {
        if (this.isInterface() || !this.loaded || this.superClassName == null) {
            return null;
        }
        return (ClassInfo)this.classInformation.get(this.superClassName);
    }

    public String getSuperClassName() {
        if (this.isInterface()) {
            return "None";
        }
        if (!this.loaded) {
            return "Unknown";
        }
        ClassInfo classInfo = this.getSuperClass();
        if (classInfo == null) {
            return "Unknown";
        }
        return classInfo.uniqueNameString();
    }

    public boolean haveMethodOfName(String string) {
        int n = 0;
        while (n < this.classMethods.size()) {
            MethodInfo methodInfo = (MethodInfo)this.classMethods.get(n);
            if (methodInfo.rawName.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public boolean load() {
        this.loaded = true;
        try {
            boolean bl = false;
            if (dataReader.getInt(2) == 51966) {
                boolean bl2 = bl = dataReader.getInt(2) == 47806;
            }
            if (!bl) {
                AnalyzerUtilities.alert("Signature Invalid: " + this.fullFileName);
                return false;
            }
            dataReader.getInt(2);
            dataReader.getInt(2);
            int n = dataReader.getInt(2);
            this.constantPool = new ConstantPool(n);
            if (!this.constantPool.fill(dataReader, n)) {
                AnalyzerUtilities.alert("Invalid data in: " + this.fullFileName);
            }
            this.accessFlags = dataReader.getInt(2);
            this.rawName = this.readConstantPoolEntryString(dataReader.getInt(2));
            this.superClassName = this.readConstantPoolEntryString(dataReader.getInt(2));
            if (this.rawName == null || this.superClassName == null && !this.rawName.equals("java/lang/Object")) {
                AnalyzerUtilities.alert("Class File Error: " + this.fullFileName);
                return false;
            }
            int n2 = dataReader.getInt(2);
            this.interfaces = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.interfaces[n3] = this.getConstantName(dataReader.getInt(2));
                ++n3;
            }
            int n4 = dataReader.getInt(2);
            n3 = 0;
            while (n3 < n4) {
                FieldInfo fieldInfo = new FieldInfo(dataReader, this);
                if (!fieldInfo.load()) {
                    AnalyzerUtilities.alert("Cannot load " + this.rawName);
                    return false;
                }
                this.classFields.add(fieldInfo, false);
                ++n3;
            }
            int n5 = dataReader.getInt(2);
            n3 = 0;
            while (n3 < n5) {
                MethodInfo methodInfo = new MethodInfo(dataReader, this);
                if (!methodInfo.load()) {
                    AnalyzerUtilities.alert("Cannot load " + this.rawName);
                    return false;
                }
                this.classMethods.add(methodInfo, false);
                ++n3;
            }
            int n6 = dataReader.getInt(2);
            String string = null;
            String string2 = null;
            this.attributes = new AttributeEntry[n6];
            n3 = 0;
            while (n3 < n6) {
                this.attributes[n3] = new AttributeEntry();
                this.attributes[n3].nameIndex = dataReader.getInt(2);
                this.attributes[n3].byteCount = dataReader.getInt(4);
                if (this.attributes[n3].byteCount == 2) {
                    this.attributes[n3].sourceIndex = dataReader.getInt(2);
                    String string3 = this.readConstantPoolEntryString(this.attributes[n3].nameIndex);
                    String string4 = this.readConstantPoolEntryString(this.attributes[n3].sourceIndex);
                    if (string3.equals("SourceFile")) {
                        string2 = string4;
                    }
                    if (string3.equals("SourceDir")) {
                        string = string4;
                    }
                } else {
                    byte[] byArray = new byte[this.attributes[n3].byteCount];
                    int n7 = 0;
                    while (n7 < this.attributes[n3].byteCount) {
                        dataReader.readByte();
                        ++n7;
                    }
                }
                ++n3;
            }
            if (string != null && string2 != null) {
                this.sourceFileName = String.valueOf(string) + string2;
            }
            this.classInformation.add(this, false);
            if (this.loadReferenced) {
                this.attemptLoadReferenced();
            }
        }
        catch (IOException iOException) {
            AnalyzerUtilities.alert("IO Exception loading " + this.rawName);
            return false;
        }
        dataReader = null;
        return true;
    }

    public Object readConstantPoolEntry(int n) {
        if (this.constantPool != null) {
            return this.constantPool.readConstantPoolEntry(n);
        }
        return null;
    }

    public String readConstantPoolEntryString(int n) {
        return (String)this.readConstantPoolEntry(n);
    }

    public void releaseMemory() {
        int n = 0;
        while (n < this.classMethods.size()) {
            ((MethodInfo)this.classMethods.get(n)).releaseMemory();
            ++n;
        }
    }

    public void resolveClassReferences() {
        this.depth = 0;
        this.tellSuperIExtend();
        this.depth = 0;
        this.addInterfacesThatIImplement(this);
    }

    public void resolveFieldReferences() {
        int n = 0;
        while (n < this.classFields.size()) {
            ((FieldInfo)this.classFields.get(n)).resolveReferences(this.classInformation);
            ++n;
        }
    }

    public void resolveMethodReferences() {
        int n = 0;
        while (n < this.classMethods.size()) {
            ((MethodInfo)this.classMethods.get(n)).resolveReferences(this.classInformation);
            ++n;
        }
    }

    private void resolveMethodReferencesVirtualx() {
    }

    public void setClassesCallMeExternally(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2, boolean bl) {
        HashedVector hashedVector2 = this.classMethods;
        int n = 0;
        while (n < hashedVector2.size()) {
            HashedVector hashedVector3 = bl ? ((MethodInfo)hashedVector2.get(n)).methodsThatInvokeMeExplicitly(hashedVector) : ((MethodInfo)hashedVector2.get(n)).methodsThatInvokeMeImplicitly(hashedVector);
            int n2 = 0;
            while (n2 < hashedVector3.size()) {
                MethodInfo methodInfo = (MethodInfo)hashedVector3.get(n2);
                if (!this.rawName.equals(methodInfo.myClassName)) {
                    uniqueVector.addElement(methodInfo.myClass.getCompleteDisplayName());
                    uniqueVector2.addElement(methodInfo.myClass);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void setClassesExtendMe(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.classesThatExtendOrImplementMe;
        int n = 0;
        while (n < hashedVector2.size()) {
            ClassInfo classInfo = (ClassInfo)hashedVector2.get(n);
            if (classInfo != this) {
                uniqueVector.addElement(classInfo.getCompleteDisplayName());
                uniqueVector2.addElement(classInfo);
            }
            ++n;
        }
    }

    public void setClassesICallBothBoth(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        UniqueVector uniqueVector3 = new UniqueVector();
        UniqueVector uniqueVector4 = new UniqueVector();
        UniqueVector uniqueVector5 = new UniqueVector();
        UniqueVector uniqueVector6 = new UniqueVector();
        this.setClassesICallExternally(hashedVector, uniqueVector3, uniqueVector4, true);
        this.setClassesICallExternally(hashedVector, uniqueVector3, uniqueVector4, false);
        AnalyzerUtilities.mergeVectors(uniqueVector, uniqueVector3, uniqueVector5);
        AnalyzerUtilities.mergeVectors(uniqueVector2, uniqueVector4, uniqueVector6);
    }

    public void setClassesICallExternally(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2, boolean bl) {
        HashedVector hashedVector2 = this.classMethods;
        int n = 0;
        while (n < hashedVector2.size()) {
            HashedVector hashedVector3 = bl ? ((MethodInfo)hashedVector2.get(n)).methodsIInvokeExplicitly(hashedVector) : ((MethodInfo)hashedVector2.get(n)).methodsIInvokeImplicitly(hashedVector);
            int n2 = 0;
            while (n2 < hashedVector3.size()) {
                MethodInfo methodInfo = (MethodInfo)hashedVector3.get(n2);
                if (!this.rawName.equals(methodInfo.myClassName)) {
                    uniqueVector.addElement(methodInfo.myClass.getCompleteDisplayName());
                    uniqueVector2.addElement(methodInfo.myClass);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void setClassesIContain(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.classFields;
        int n = 0;
        while (n < hashedVector2.size()) {
            FieldInfo fieldInfo = (FieldInfo)hashedVector2.get(n);
            String string = fieldInfo.myClassTypeName();
            if (string != null) {
                ClassInfo classInfo = (ClassInfo)hashedVector.get(string);
                if (classInfo == null) {
                    AnalyzerUtilities.alert("ClassInfo: cannot find contained class for " + fieldInfo.rawName);
                } else {
                    uniqueVector.addElement(fieldInfo.myClass.getCompleteDisplayName());
                    uniqueVector2.addElement(classInfo);
                }
            }
            ++n;
        }
    }

    public void setClassesICreate(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.classMethods;
        int n = 0;
        while (n < hashedVector2.size()) {
            HashedVector hashedVector3 = ((MethodInfo)hashedVector2.get(n)).classesICreate(hashedVector);
            int n2 = 0;
            while (n2 < hashedVector3.size()) {
                ClassInfo classInfo = (ClassInfo)hashedVector3.get(n2);
                uniqueVector.addElement(classInfo.getCompleteDisplayName());
                uniqueVector2.addElement(classInfo);
                ++n2;
            }
            ++n;
        }
    }

    public void setClassesIExtend(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        ClassInfo classInfo = this;
        while ((classInfo = classInfo.getSuperClass()) != null) {
            uniqueVector.addElement(classInfo.getCompleteDisplayName());
            uniqueVector2.addElement(classInfo);
        }
    }

    public void setClassesIImplement(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.interfacesIExtendOrImplement;
        int n = 0;
        while (n < hashedVector2.size()) {
            ClassInfo classInfo = (ClassInfo)hashedVector2.get(n);
            if (classInfo != this) {
                uniqueVector.addElement(classInfo.getCompleteDisplayName());
                uniqueVector2.addElement(classInfo);
            }
            ++n;
        }
    }

    public void setClassesIRead(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.classMethods;
        int n = 0;
        while (n < hashedVector2.size()) {
            HashedVector hashedVector3 = ((MethodInfo)hashedVector2.get(n)).fieldsIRead(hashedVector);
            int n2 = 0;
            while (n2 < hashedVector3.size()) {
                FieldInfo fieldInfo = (FieldInfo)hashedVector3.get(n2);
                uniqueVector.addElement(fieldInfo.myClass.getCompleteDisplayName());
                uniqueVector2.addElement(fieldInfo.myClass);
                ++n2;
            }
            ++n;
        }
    }

    public void setClassesIRef(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.classesIRef;
        int n = 0;
        while (n < hashedVector2.size()) {
            ClassInfo classInfo = (ClassInfo)hashedVector2.get(n);
            if (classInfo != this) {
                uniqueVector.addElement(classInfo.getCompleteDisplayName());
                uniqueVector2.addElement(classInfo);
            }
            ++n;
        }
    }

    public void setClassesIWrite(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.classMethods;
        int n = 0;
        while (n < hashedVector2.size()) {
            HashedVector hashedVector3 = ((MethodInfo)hashedVector2.get(n)).fieldsIWrite(hashedVector);
            int n2 = 0;
            while (n2 < hashedVector3.size()) {
                FieldInfo fieldInfo = (FieldInfo)hashedVector3.get(n2);
                uniqueVector.addElement(fieldInfo.myClass.getCompleteDisplayName());
                uniqueVector2.addElement(fieldInfo.myClass);
                ++n2;
            }
            ++n;
        }
    }

    public void setClassesRefMe(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.classesThatRefMe;
        int n = 0;
        while (n < hashedVector2.size()) {
            ClassInfo classInfo = (ClassInfo)hashedVector2.get(n);
            if (classInfo != this) {
                uniqueVector.addElement(classInfo.getCompleteDisplayName());
                uniqueVector2.addElement(classInfo);
            }
            ++n;
        }
    }

    public void setFieldsContainMe(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.fieldsOfMyType;
        int n = 0;
        while (n < hashedVector2.size()) {
            FieldInfo fieldInfo = (FieldInfo)hashedVector2.get(n);
            uniqueVector.addElement(fieldInfo.getCompleteDisplayName());
            uniqueVector2.addElement(fieldInfo);
            ++n;
        }
    }

    public void setFieldsIDefine(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.classFields;
        int n = 0;
        while (n < hashedVector2.size()) {
            FieldInfo fieldInfo = (FieldInfo)hashedVector2.get(n);
            uniqueVector.addElement(fieldInfo.getFieldDisplayName());
            uniqueVector2.addElement(fieldInfo);
            ++n;
        }
    }

    public void setFieldsIReadBoth(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.classMethods;
        int n = 0;
        while (n < hashedVector2.size()) {
            HashedVector hashedVector3 = ((MethodInfo)hashedVector2.get(n)).fieldsIRead(hashedVector);
            int n2 = 0;
            while (n2 < hashedVector3.size()) {
                FieldInfo fieldInfo = (FieldInfo)hashedVector3.get(n2);
                uniqueVector.addElement(fieldInfo.getCompleteDisplayName());
                uniqueVector2.addElement(fieldInfo);
                ++n2;
            }
            ++n;
        }
    }

    public void setFieldsIWriteBoth(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.classMethods;
        int n = 0;
        while (n < hashedVector2.size()) {
            HashedVector hashedVector3 = ((MethodInfo)hashedVector2.get(n)).fieldsIWrite(hashedVector);
            int n2 = 0;
            while (n2 < hashedVector3.size()) {
                FieldInfo fieldInfo = (FieldInfo)hashedVector3.get(n2);
                uniqueVector.addElement(fieldInfo.getCompleteDisplayName());
                uniqueVector2.addElement(fieldInfo);
                ++n2;
            }
            ++n;
        }
    }

    public void setMethodsCallMeExternally(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2, boolean bl) {
        HashedVector hashedVector2 = this.classMethods;
        int n = 0;
        while (n < hashedVector2.size()) {
            HashedVector hashedVector3 = bl ? ((MethodInfo)hashedVector2.get(n)).methodsThatInvokeMeExplicitly(hashedVector) : ((MethodInfo)hashedVector2.get(n)).methodsThatInvokeMeImplicitly(hashedVector);
            int n2 = 0;
            while (n2 < hashedVector3.size()) {
                MethodInfo methodInfo = (MethodInfo)hashedVector3.get(n2);
                if (!this.rawName.equals(methodInfo.myClassName)) {
                    uniqueVector.addElement(methodInfo.getCompleteDisplayName());
                    uniqueVector2.addElement(methodInfo);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void setMethodsCreateMe(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.methodsThatCreateMe;
        int n = 0;
        while (n < hashedVector2.size()) {
            MethodInfo methodInfo = (MethodInfo)hashedVector2.get(n);
            uniqueVector.addElement(methodInfo.getCompleteDisplayName());
            uniqueVector2.addElement(methodInfo);
            ++n;
        }
    }

    public void setMethodsICallExternally(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2, boolean bl) {
        HashedVector hashedVector2 = this.classMethods;
        int n = 0;
        while (n < hashedVector2.size()) {
            HashedVector hashedVector3 = bl ? ((MethodInfo)hashedVector2.get(n)).methodsIInvokeExplicitly(hashedVector) : ((MethodInfo)hashedVector2.get(n)).methodsIInvokeImplicitly(hashedVector);
            int n2 = 0;
            while (n2 < hashedVector3.size()) {
                MethodInfo methodInfo = (MethodInfo)hashedVector3.get(n2);
                if (!this.rawName.equals(methodInfo.myClassName)) {
                    uniqueVector.addElement(methodInfo.getCompleteDisplayName());
                    uniqueVector2.addElement(methodInfo);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void setMethodsReadMe(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.classFields;
        int n = 0;
        while (n < hashedVector2.size()) {
            HashedVector hashedVector3 = ((FieldInfo)hashedVector2.get((int)n)).methodsThatReadMe;
            int n2 = 0;
            while (n2 < hashedVector3.size()) {
                MethodInfo methodInfo = (MethodInfo)hashedVector3.get(n2);
                if (!this.rawName.equals(methodInfo.myClassName)) {
                    uniqueVector.addElement(methodInfo.getCompleteDisplayName());
                    uniqueVector2.addElement(methodInfo);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void setMethodsWriteMe(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.classFields;
        int n = 0;
        while (n < hashedVector2.size()) {
            HashedVector hashedVector3 = ((FieldInfo)hashedVector2.get((int)n)).methodsThatWriteMe;
            int n2 = 0;
            while (n2 < hashedVector3.size()) {
                MethodInfo methodInfo = (MethodInfo)hashedVector3.get(n2);
                if (!this.rawName.equals(methodInfo.myClassName)) {
                    uniqueVector.addElement(methodInfo.getCompleteDisplayName());
                    uniqueVector2.addElement(methodInfo);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void setMyMethods(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.classMethods;
        int n = 0;
        while (n < hashedVector2.size()) {
            MethodInfo methodInfo = (MethodInfo)hashedVector2.get(n);
            uniqueVector.addElement(methodInfo.getMethodDisplayName());
            uniqueVector2.addElement(methodInfo);
            ++n;
        }
    }

    private void tellSuperIExtend() {
        ClassInfo classInfo;
        ClassInfo classInfo2 = this;
        while ((classInfo = classInfo2.getSuperClass()) != null) {
            classInfo.classesThatExtendOrImplementMe.add(this, true);
            classInfo2 = classInfo;
        }
    }

    public char[] uniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = this.rawName.toCharArray();
        }
        return this.uniqueName;
    }

    public String uniqueNameString() {
        return this.rawName;
    }
}

