/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer.info;

import java.io.IOException;
import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.ClassFileInputStream;
import org.apache.tools.analyzer.HashedVector;
import org.apache.tools.analyzer.UniqueVector;
import org.apache.tools.analyzer.info.ClassInfo;
import org.apache.tools.analyzer.info.FieldAttributeEntry;
import org.apache.tools.analyzer.info.MethodInfo;
import org.apache.tools.analyzer.info.UnitInfo;

public class FieldInfo
extends UnitInfo {
    private static ClassFileInputStream read;
    private int accessFlags;
    public HashedVector methodsThatReadMe = new HashedVector();
    public HashedVector methodsThatWriteMe = new HashedVector();
    private FieldAttributeEntry[] attributes;
    private int attributesCount;
    public String myClassName;
    public ClassInfo myClass;

    FieldInfo(ClassFileInputStream classFileInputStream, ClassInfo classInfo) {
        read = classFileInputStream;
        this.myClass = classInfo;
        this.myClassName = this.myClass.rawName;
    }

    public FieldInfo(ClassInfo classInfo, String string) {
        this.myClass = classInfo;
        this.rawName = string;
        this.myClassName = classInfo.rawName;
        this.loaded = false;
    }

    public String getClassOnlyDisplayName() {
        return this.myClass.getClassOnlyDisplayName();
    }

    public String getCompleteDisplayName() {
        return String.valueOf(this.myClass.getCompleteDisplayName()) + "." + this.getFieldDisplayName();
    }

    public String getFieldDisplayName() {
        return String.valueOf(this.rawName.substring(0, this.rawName.indexOf(":"))) + " (" + this.myTypeName() + ")";
    }

    public String getFieldOnlyName() {
        return this.rawName.substring(0, this.rawName.indexOf(":"));
    }

    public String getRawPackageName() {
        return this.myClass.getRawPackageName();
    }

    public String getStatuses() {
        if (!this.myClass.loaded) {
            return "";
        }
        String string = this.isPublic() ? "public " : (this.isPrivate() ? "private " : (this.isProtected() ? "protected " : ""));
        if (this.isStatic()) {
            string = String.valueOf(string) + "static ";
        }
        if (this.isFinal()) {
            string = String.valueOf(string) + "final ";
        }
        if (this.isVolatile()) {
            string = String.valueOf(string) + "volatile ";
        }
        if (this.isTransient()) {
            string = String.valueOf(string) + "transient ";
        }
        return string;
    }

    public String getStatusesExFinal() {
        if (!this.myClass.loaded) {
            return "";
        }
        String string = this.isPublic() ? "public " : (this.isPrivate() ? "private " : (this.isProtected() ? "protected " : ""));
        if (this.isStatic()) {
            string = String.valueOf(string) + "static ";
        }
        if (this.isVolatile()) {
            string = String.valueOf(string) + "volatile ";
        }
        if (this.isTransient()) {
            string = String.valueOf(string) + "transient ";
        }
        return string;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isPrivate() {
        return (this.accessFlags & 2) != 0;
    }

    public boolean isProtected() {
        return (this.accessFlags & 4) != 0;
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public boolean isTransient() {
        return (this.accessFlags & 0x80) != 0;
    }

    public boolean isVolatile() {
        return (this.accessFlags & 0x40) != 0;
    }

    public boolean load() {
        try {
            this.loaded = true;
            this.accessFlags = read.getInt(2);
            int n = read.getInt(2);
            int n2 = read.getInt(2);
            this.rawName = String.valueOf(String.valueOf(this.myClass.readConstantPoolEntry(n))) + ":" + this.myClass.readConstantPoolEntry(n2);
            this.attributesCount = read.getInt(2);
            if (this.attributesCount != 0) {
                this.attributes = new FieldAttributeEntry[this.attributesCount];
                int n3 = 0;
                while (n3 < this.attributesCount) {
                    int n4 = read.getInt(2);
                    String string = this.myClass.readConstantPoolEntryString(n4);
                    int n5 = read.getInt(4);
                    if (n5 == 2) {
                        this.attributes[n3] = new FieldAttributeEntry();
                        this.attributes[n3].valueIndex = read.getInt(2);
                    } else {
                        this.attributes[n3] = new FieldAttributeEntry();
                        this.attributes[n3].valueIndex = -1;
                        int n6 = 0;
                        while (n6 < n5) {
                            read.next();
                            ++n6;
                        }
                        String string2 = this.myClass.readConstantPoolEntryString(n4);
                    }
                    ++n3;
                }
            }
            read = null;
            return true;
        }
        catch (IOException iOException) {
            AnalyzerUtilities.alert("IO Exception loading " + this.myClassName + " " + this.rawName);
            return false;
        }
    }

    public String myClassTypeName() {
        String string = this.rawName.substring(this.rawName.indexOf(":") + 1, this.rawName.length());
        return AnalyzerUtilities.getFieldClassType(string);
    }

    public String myTypeName() {
        return AnalyzerUtilities.getFieldType(this.rawName.substring(this.rawName.indexOf(":") + 1, this.rawName.length()));
    }

    public void resolveReferences(HashedVector hashedVector) {
        String string = this.myClassTypeName();
        if (string != null) {
            ClassInfo classInfo = (ClassInfo)hashedVector.get(string);
            if (classInfo == null) {
                AnalyzerUtilities.alert("FieldInfo: Cannot find class for " + this.rawName);
            } else {
                classInfo.fieldsOfMyType.add(this, true);
            }
        }
    }

    public void setClassesReadMe(UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector = this.methodsThatReadMe;
        int n = 0;
        while (n < hashedVector.size()) {
            MethodInfo methodInfo = (MethodInfo)hashedVector.get(n);
            uniqueVector.addElement(methodInfo.myClass.getCompleteDisplayName());
            uniqueVector2.addElement(methodInfo.myClass);
            ++n;
        }
    }

    public void setClassesWriteMe(UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector = this.methodsThatWriteMe;
        int n = 0;
        while (n < hashedVector.size()) {
            MethodInfo methodInfo = (MethodInfo)hashedVector.get(n);
            uniqueVector.addElement(methodInfo.myClass.getCompleteDisplayName());
            uniqueVector2.addElement(methodInfo.myClass);
            ++n;
        }
    }

    public void setMethodsReadMe(UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector = this.methodsThatReadMe;
        int n = 0;
        while (n < hashedVector.size()) {
            MethodInfo methodInfo = (MethodInfo)hashedVector.get(n);
            uniqueVector.addElement(methodInfo.getCompleteDisplayName());
            uniqueVector2.addElement(methodInfo);
            ++n;
        }
    }

    public void setMethodsWriteMe(UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector = this.methodsThatWriteMe;
        int n = 0;
        while (n < hashedVector.size()) {
            MethodInfo methodInfo = (MethodInfo)hashedVector.get(n);
            uniqueVector.addElement(methodInfo.getCompleteDisplayName());
            uniqueVector2.addElement(methodInfo);
            ++n;
        }
    }

    public char[] uniqueName() {
        if (this.uniqueName == null) {
            String string = String.valueOf(this.myClass.rawName) + "." + this.rawName;
            this.uniqueName = string.toCharArray();
        }
        return this.uniqueName;
    }

    public String uniqueNameString() {
        return String.valueOf(this.myClass.rawName) + "." + this.rawName;
    }
}

