/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer.info;

import java.io.IOException;
import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.ClassFileInputStream;
import org.apache.tools.analyzer.Decompiler;
import org.apache.tools.analyzer.ExpandableArray;
import org.apache.tools.analyzer.HashedVector;
import org.apache.tools.analyzer.IStatusListener;
import org.apache.tools.analyzer.UniqueVector;
import org.apache.tools.analyzer.info.ClassInfo;
import org.apache.tools.analyzer.info.FieldInfo;
import org.apache.tools.analyzer.info.UnitInfo;
import org.apache.tools.analyzer.structures.MACodeEntry;
import org.apache.tools.analyzer.structures.MAEntry;
import org.apache.tools.analyzer.structures.MAExceptionEntry;

public class MethodInfo
extends UnitInfo {
    public static int VIRTUAL = 1;
    public static int INTERFACE = 3;
    public static int DIRECT = 5;
    public static int READ = 7;
    public static int WRITE = 9;
    public static int CREATE = 11;
    private static int IINVOKEEXP = 15;
    private static int INVOKEMEEXP = 17;
    private static int IINVOKEIMP = 19;
    public static ClassFileInputStream read;
    private UniqueVector relations = new UniqueVector(5, 5);
    private ExpandableArray relationshipTypes = new ExpandableArray();
    private ExpandableArray interactions = new ExpandableArray();
    private UniqueVector methodsOverrideOrImplementMe = null;
    private MAEntry[] attributes;
    private int attributesCount;
    public String myClassName;
    public ClassInfo myClass;
    private int accessFlags;
    private boolean resolveVirtual = false;

    private MethodInfo(String string, ClassInfo classInfo) {
        this.rawName = string;
        this.myClass = classInfo;
        this.myClassName = this.myClass.rawName;
        this.loaded = false;
    }

    MethodInfo(ClassFileInputStream classFileInputStream, ClassInfo classInfo) {
        read = classFileInputStream;
        this.myClass = classInfo;
        this.myClassName = this.myClass.rawName;
    }

    private FieldInfo addNonLoadedFieldEntry(String string, ClassInfo classInfo) {
        String string2 = this.getMethodFieldPart(string);
        FieldInfo fieldInfo = new FieldInfo(classInfo, string2);
        classInfo.classFields.add(fieldInfo, true);
        return fieldInfo;
    }

    private MethodInfo addNonLoadedMethodEntry(String string, ClassInfo classInfo) {
        String string2 = this.getMethodFieldPart(string);
        MethodInfo methodInfo = new MethodInfo(string2, classInfo);
        classInfo.classMethods.add(methodInfo, true);
        return methodInfo;
    }

    private void addRelationship(int n, UnitInfo unitInfo) {
        if (unitInfo == null) {
            AnalyzerUtilities.alert("Null in addRelationship");
            return;
        }
        this.relations.addElement(unitInfo);
        this.relationshipTypes.add(n);
    }

    private void buildOverrides() {
        HashedVector hashedVector = this.myClass.classesThatExtendOrImplementMe;
        this.methodsOverrideOrImplementMe = new UniqueVector(1, 1);
        if (this.isInitializer()) {
            return;
        }
        int n = 0;
        while (n < hashedVector.size()) {
            MethodInfo methodInfo = this.methodOfSameNameIn((ClassInfo)hashedVector.get(n));
            if (methodInfo != null) {
                this.methodsOverrideOrImplementMe.addElement(methodInfo);
            }
            ++n;
        }
    }

    public HashedVector classesICreate(HashedVector hashedVector) {
        return this.filter(CREATE);
    }

    public UniqueVector decompile(IStatusListener iStatusListener, boolean bl) {
        return Decompiler.listMethod(this, iStatusListener, bl);
    }

    public HashedVector fieldsIRead(HashedVector hashedVector) {
        return this.filter(READ);
    }

    public HashedVector fieldsIWrite(HashedVector hashedVector) {
        return this.filter(WRITE);
    }

    public HashedVector filter(int n) {
        HashedVector hashedVector = new HashedVector();
        int n2 = 0;
        while (n2 < this.relations.size()) {
            if (this.relationshipTypes.get(n2) == n) {
                hashedVector.add((UnitInfo)this.relations.elementAt(n2), true);
            }
            ++n2;
        }
        return hashedVector;
    }

    public String getBlockDisplayName() {
        return this.getCompleteDisplayName();
    }

    public String getClassOnlyDisplayName() {
        return this.myClass.getClassOnlyDisplayName();
    }

    private String getClassPart(String string) {
        return string.substring(0, string.indexOf(AnalyzerUtilities.nameAndExtensionSeparator));
    }

    public MACodeEntry getCodeEntry() {
        int n = 0;
        while (n < this.attributesCount) {
            if (this.attributes[n] instanceof MACodeEntry) {
                return (MACodeEntry)this.attributes[n];
            }
            ++n;
        }
        return null;
    }

    public String getCompleteDisplayName() {
        return String.valueOf(this.myClass.getCompleteDisplayName()) + "." + this.getMethodDisplayName();
    }

    public MAExceptionEntry getExceptionEntry() {
        int n = 0;
        while (n < this.attributesCount) {
            if (this.attributes[n] instanceof MAExceptionEntry) {
                return (MAExceptionEntry)this.attributes[n];
            }
            ++n;
        }
        return null;
    }

    public String getMethodDisplayName() {
        String string = this.rawName.substring(0, this.rawName.indexOf(":"));
        String string2 = this.rawName.substring(this.rawName.indexOf(":") + 1, this.rawName.length());
        if (string.equals("<init>")) {
            string = this.myClass.getClassOnlyDisplayName();
        }
        String string3 = AnalyzerUtilities.getMethodType(string2);
        String string4 = AnalyzerUtilities.getMethodParameterString(string2);
        return String.valueOf(string) + string4 + " >> " + string3;
    }

    private String getMethodFieldPart(String string) {
        return string.substring(string.indexOf(AnalyzerUtilities.nameAndExtensionSeparator) + 1, string.length());
    }

    public String getMethodOnlyName() {
        return this.rawName.substring(0, this.rawName.indexOf(":"));
    }

    public String getMethodSourceName() {
        String string = this.rawName.substring(0, this.rawName.indexOf(":"));
        String string2 = this.rawName.substring(this.rawName.indexOf(":") + 1, this.rawName.length());
        if (string.equals("<init>")) {
            string = this.myClass.getClassOnlyDisplayName();
        }
        String string3 = AnalyzerUtilities.getMethodType(string2);
        String string4 = AnalyzerUtilities.getMethodParameterString(string2);
        return String.valueOf(string3) + " " + string + string4;
    }

    public String getRawPackageName() {
        return this.myClass.getRawPackageName();
    }

    public String getSourceMethodName() {
        String string = this.rawName.substring(0, this.rawName.indexOf(":"));
        if (string.equals("<init>")) {
            string = this.myClass.getClassOnlyDisplayName();
        }
        return string;
    }

    public String getStatuses() {
        return this.getStatuses(true);
    }

    public String getStatuses(boolean bl) {
        if (!this.myClass.loaded) {
            return "";
        }
        String string = this.isPublic() ? "public " : (this.isPrivate() ? "private " : (this.isProtected() ? "protected " : ""));
        if (this.isStatic()) {
            string = String.valueOf(string) + "static ";
        }
        if (this.isAbstract() && bl) {
            string = String.valueOf(string) + "abstract ";
        }
        if (this.isFinal()) {
            string = String.valueOf(string) + "final ";
        }
        if (this.isNative()) {
            string = String.valueOf(string) + "native ";
        }
        if (this.isSynchronized()) {
            string = String.valueOf(string) + "synchronized ";
        }
        return string;
    }

    public String getStatusesExcAbstract() {
        return this.getStatuses(false);
    }

    public boolean implementsInterface() {
        HashedVector hashedVector = this.myClass.interfacesIExtendOrImplement;
        int n = 0;
        while (n < hashedVector.size()) {
            if (this.methodOfSameNameIn((ClassInfo)hashedVector.get(n)) != null) {
                return true;
            }
            ++n;
        }
        ClassInfo classInfo = this.myClass.getSuperClass();
        if (classInfo == null) {
            return false;
        }
        MethodInfo methodInfo = this.methodOfSameNameIn(classInfo);
        return methodInfo != null && methodInfo.isAbstract();
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isInitializer() {
        return this.rawName.indexOf(60) >= 0;
    }

    public boolean isNative() {
        return (this.accessFlags & 0x100) != 0;
    }

    public boolean isPrivate() {
        return (this.accessFlags & 2) != 0;
    }

    public boolean isProtected() {
        return (this.accessFlags & 4) != 0;
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public boolean isSynchronized() {
        return (this.accessFlags & 0x20) != 0;
    }

    public boolean load() {
        try {
            this.loaded = true;
            this.accessFlags = read.getInt(2);
            int n = read.getInt(2);
            int n2 = read.getInt(2);
            this.rawName = String.valueOf(String.valueOf(this.myClass.readConstantPoolEntry(n))) + ":" + this.myClass.readConstantPoolEntry(n2);
            this.attributesCount = read.getInt(2);
            if (this.attributesCount != 0) {
                this.attributes = new MAEntry[this.attributesCount];
                int n3 = 0;
                while (n3 < this.attributesCount) {
                    int n4 = read.getInt(2);
                    if ("Exceptions".equals(this.myClass.readConstantPoolEntry(n4))) {
                        this.attributes[n3] = new MAExceptionEntry(read, this.myClass);
                    } else if ("Code".equals(this.myClass.readConstantPoolEntry(n4))) {
                        this.attributes[n3] = new MACodeEntry();
                        this.interactions = ((MACodeEntry)this.attributes[n3]).loadEntry(read, this.myClass, this, true);
                        if (this.interactions == null) {
                            return false;
                        }
                    } else {
                        int n5 = read.getInt(4);
                        int n6 = 0;
                        while (n6 < n5) {
                            read.next();
                            ++n6;
                        }
                    }
                    ++n3;
                }
            }
            return true;
        }
        catch (IOException iOException) {
            AnalyzerUtilities.alert("IO Exception loading " + this.myClassName + " " + this.rawName);
            return false;
        }
    }

    private MethodInfo methodOfSameNameIn(ClassInfo classInfo) {
        int n = 0;
        while (n < classInfo.classMethods.size()) {
            MethodInfo methodInfo = (MethodInfo)classInfo.classMethods.get(n);
            if (methodInfo.rawName.equals(this.rawName)) {
                return methodInfo;
            }
            ++n;
        }
        return null;
    }

    public HashedVector methodsIInvokeExplicitly(HashedVector hashedVector) {
        return this.filter(IINVOKEEXP);
    }

    public HashedVector methodsIInvokeImplicitly(HashedVector hashedVector) {
        if (!this.resolveVirtual) {
            this.resolveReferencesVirtual(this.myClass.classInformation);
            this.resolveVirtual = true;
        }
        return this.filter(IINVOKEIMP);
    }

    public HashedVector methodsThatInvokeMeExplicitly(HashedVector hashedVector) {
        return this.filter(INVOKEMEEXP);
    }

    public HashedVector methodsThatInvokeMeImplicitly(HashedVector hashedVector) {
        HashedVector hashedVector2 = new HashedVector();
        HashedVector hashedVector3 = this.myClass.allMyPredecessors();
        int n = 0;
        while (n < hashedVector3.size()) {
            MethodInfo methodInfo = this.methodOfSameNameIn((ClassInfo)hashedVector3.get(n));
            if (methodInfo != null) {
                hashedVector2.add(methodInfo.methodsThatInvokeMeExplicitly(this.myClass.classInformation), true);
            }
            ++n;
        }
        return hashedVector2;
    }

    public UniqueVector myClassTypeNames() {
        int n = this.rawName.indexOf(":");
        if (n >= 0) {
            String string = this.rawName.substring(n + 1, this.rawName.length());
            UniqueVector uniqueVector = AnalyzerUtilities.getTypeAndParamterReferencedClasses(string);
            return uniqueVector;
        }
        AnalyzerUtilities.alert("MethodInfo:Unknown type and parameters : " + this.rawName);
        return null;
    }

    public String myType() {
        int n = this.rawName.indexOf(":");
        if (n >= 0) {
            String string = this.rawName.substring(n + 1, this.rawName.length());
            String string2 = AnalyzerUtilities.getMethodType(string);
            return string2;
        }
        return "Unknown";
    }

    public UniqueVector parameterList() {
        int n = this.rawName.indexOf(":");
        if (n >= 0) {
            String string = this.rawName.substring(n + 1, this.rawName.length());
            return AnalyzerUtilities.getMethodParameters(string, new UniqueVector());
        }
        return null;
    }

    public void releaseMemory() {
    }

    private void resolveField(int n, HashedVector hashedVector, int n2) {
        String string = this.myClass.readConstantPoolEntryString(n);
        ClassInfo classInfo = (ClassInfo)hashedVector.get(this.getClassPart(string));
        if (classInfo == null) {
            AnalyzerUtilities.alert("FieldInfo.resolveField: could not find class " + this.getClassPart(string));
            return;
        }
        FieldInfo fieldInfo = (FieldInfo)classInfo.classFields.get(string);
        if (fieldInfo == null) {
            if (classInfo.loaded) {
                AnalyzerUtilities.alert("Could not find field " + string + " in loaded class. Adding reference.");
            }
            fieldInfo = this.addNonLoadedFieldEntry(string, classInfo);
        }
        if (n2 == READ) {
            this.addRelationship(READ, fieldInfo);
            fieldInfo.methodsThatReadMe.add(this, true);
        } else {
            this.addRelationship(WRITE, fieldInfo);
            fieldInfo.methodsThatWriteMe.add(this, true);
        }
    }

    private void resolveMethod(int n, HashedVector hashedVector, int n2) {
        String string = this.myClass.readConstantPoolEntryString(n);
        String string2 = this.getClassPart(string);
        ClassInfo classInfo = (ClassInfo)hashedVector.get(string2);
        if (classInfo == null) {
            AnalyzerUtilities.alert("ResolveMethod: could not find " + string2);
            return;
        }
        MethodInfo methodInfo = (MethodInfo)classInfo.classMethods.get(string);
        if (methodInfo == null) {
            if (classInfo.loaded) {
                AnalyzerUtilities.alert("Could not find method " + string + " in loaded class. Adding reference.");
            }
            methodInfo = this.addNonLoadedMethodEntry(string, classInfo);
        }
        this.addRelationship(IINVOKEEXP, methodInfo);
        methodInfo.addRelationship(INVOKEMEEXP, this);
    }

    public void resolveReferences(HashedVector hashedVector) {
        int n = 0;
        while (n < this.interactions.size()) {
            int n2 = this.interactions.get(n);
            int n3 = n2 >> 16;
            if (n3 == VIRTUAL || n3 == DIRECT || n3 == INTERFACE) {
                this.resolveMethod(n2 & AnalyzerUtilities.BITS16, hashedVector, n3);
            } else if (n3 == READ || n3 == WRITE) {
                this.resolveField(n2 & AnalyzerUtilities.BITS16, hashedVector, n3);
            } else {
                String string = this.myClass.readConstantPoolEntryString(n2 & AnalyzerUtilities.BITS16);
                ClassInfo classInfo = (ClassInfo)hashedVector.get(string);
                if (classInfo == null) {
                    AnalyzerUtilities.alert("MethodInfo: Could not find class " + string);
                } else {
                    this.addRelationship(CREATE, classInfo);
                    classInfo.methodsThatCreateMe.add(this, true);
                }
            }
            ++n;
        }
    }

    private void resolveReferencesVirtual(HashedVector hashedVector) {
        int n = 0;
        while (n < this.interactions.size()) {
            int n2 = this.interactions.get(n);
            int n3 = n2 >> 16;
            if (n3 == VIRTUAL || n3 == INTERFACE) {
                this.resolveReferencesVirtualForCalledMethod(n2 & AnalyzerUtilities.BITS16, hashedVector, n3);
            }
            ++n;
        }
    }

    private void resolveReferencesVirtualForCalledMethod(int n, HashedVector hashedVector, int n2) {
        String string = this.myClass.readConstantPoolEntryString(n);
        ClassInfo classInfo = (ClassInfo)hashedVector.get(this.getClassPart(string));
        if (classInfo == null) {
            AnalyzerUtilities.alert("MethodInfo.resolveVirtual: could not find class" + this.getClassPart(string));
            return;
        }
        MethodInfo methodInfo = (MethodInfo)classInfo.classMethods.get(string);
        if (methodInfo == null) {
            AnalyzerUtilities.alert("Resolve Virtual References: Cannot find referenced method");
            return;
        }
        if (methodInfo.methodsOverrideOrImplementMe == null) {
            methodInfo.buildOverrides();
        }
        UniqueVector uniqueVector = methodInfo.methodsOverrideOrImplementMe;
        int n3 = 0;
        while (n3 < uniqueVector.size()) {
            this.addRelationship(IINVOKEIMP, (MethodInfo)uniqueVector.elementAt(n3));
            ++n3;
        }
    }

    public void setClassesCallMeBoth(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2, boolean bl) {
        HashedVector hashedVector2 = bl ? this.methodsThatInvokeMeExplicitly(hashedVector) : this.methodsThatInvokeMeImplicitly(hashedVector);
        int n = 0;
        while (n < hashedVector2.size()) {
            ClassInfo classInfo = ((MethodInfo)hashedVector2.get((int)n)).myClass;
            uniqueVector.addElement(classInfo.getCompleteDisplayName());
            uniqueVector2.addElement(classInfo);
            ++n;
        }
    }

    public void setClassesICallBoth(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2, boolean bl) {
        HashedVector hashedVector2 = bl ? this.methodsIInvokeExplicitly(hashedVector) : this.methodsIInvokeImplicitly(hashedVector);
        int n = 0;
        while (n < hashedVector2.size()) {
            ClassInfo classInfo = ((MethodInfo)hashedVector2.get((int)n)).myClass;
            uniqueVector.addElement(classInfo.getCompleteDisplayName());
            uniqueVector2.addElement(classInfo);
            ++n;
        }
    }

    public void setClassesICreate(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.classesICreate(hashedVector);
        int n = 0;
        while (n < hashedVector2.size()) {
            ClassInfo classInfo = (ClassInfo)hashedVector2.get(n);
            uniqueVector.addElement(classInfo.getCompleteDisplayName());
            uniqueVector2.addElement(classInfo);
            ++n;
        }
    }

    public void setClassesIRead(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.fieldsIRead(hashedVector);
        int n = 0;
        while (n < hashedVector2.size()) {
            ClassInfo classInfo = ((FieldInfo)hashedVector2.get((int)n)).myClass;
            uniqueVector.addElement(classInfo.getCompleteDisplayName());
            uniqueVector2.addElement(classInfo);
            ++n;
        }
    }

    public void setClassesIWrite(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.fieldsIWrite(hashedVector);
        int n = 0;
        while (n < hashedVector2.size()) {
            ClassInfo classInfo = ((FieldInfo)hashedVector2.get((int)n)).myClass;
            uniqueVector.addElement(classInfo.getCompleteDisplayName());
            uniqueVector2.addElement(classInfo);
            ++n;
        }
    }

    public void setClassesOverrideMe(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.myClass.classesThatExtendOrImplementMe;
        int n = 0;
        while (n < hashedVector2.size()) {
            ClassInfo classInfo = (ClassInfo)hashedVector2.get(n);
            if (this.methodOfSameNameIn(classInfo) != null) {
                uniqueVector.addElement(classInfo.getCompleteDisplayName());
                uniqueVector2.addElement(classInfo);
            }
            ++n;
        }
    }

    public void setFieldsIRead(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.fieldsIRead(hashedVector);
        int n = 0;
        while (n < hashedVector2.size()) {
            FieldInfo fieldInfo = (FieldInfo)hashedVector2.get(n);
            uniqueVector.addElement(fieldInfo.getCompleteDisplayName());
            uniqueVector2.addElement(fieldInfo);
            ++n;
        }
    }

    public void setFieldsIWrite(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.fieldsIWrite(hashedVector);
        int n = 0;
        while (n < hashedVector2.size()) {
            FieldInfo fieldInfo = (FieldInfo)hashedVector2.get(n);
            uniqueVector.addElement(fieldInfo.getCompleteDisplayName());
            uniqueVector2.addElement(fieldInfo);
            ++n;
        }
    }

    public void setMethodsCallMeBoth(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2, boolean bl) {
        HashedVector hashedVector2 = bl ? this.methodsThatInvokeMeExplicitly(hashedVector) : this.methodsThatInvokeMeImplicitly(hashedVector);
        int n = 0;
        while (n < hashedVector2.size()) {
            MethodInfo methodInfo = (MethodInfo)hashedVector2.get(n);
            uniqueVector.addElement(methodInfo.getCompleteDisplayName());
            uniqueVector2.addElement(methodInfo);
            ++n;
        }
    }

    public void setMethodsCallMeInternally(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2, boolean bl) {
        HashedVector hashedVector2 = bl ? this.methodsThatInvokeMeExplicitly(hashedVector) : this.methodsThatInvokeMeImplicitly(hashedVector);
        int n = 0;
        while (n < hashedVector2.size()) {
            MethodInfo methodInfo = (MethodInfo)hashedVector2.get(n);
            if (methodInfo.myClass == this.myClass) {
                uniqueVector.addElement(methodInfo.getCompleteDisplayName());
                uniqueVector2.addElement(methodInfo);
            }
            ++n;
        }
    }

    public void setMethodsICallBoth(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2, boolean bl) {
        HashedVector hashedVector2 = bl ? this.methodsIInvokeExplicitly(hashedVector) : this.methodsIInvokeImplicitly(hashedVector);
        int n = 0;
        while (n < hashedVector2.size()) {
            MethodInfo methodInfo = (MethodInfo)hashedVector2.get(n);
            uniqueVector.addElement(methodInfo.getCompleteDisplayName());
            uniqueVector2.addElement(methodInfo);
            ++n;
        }
    }

    public void setMethodsICallBothBoth(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        UniqueVector uniqueVector3 = new UniqueVector();
        UniqueVector uniqueVector4 = new UniqueVector();
        UniqueVector uniqueVector5 = new UniqueVector();
        UniqueVector uniqueVector6 = new UniqueVector();
        this.setMethodsICallBoth(hashedVector, uniqueVector3, uniqueVector4, true);
        this.setMethodsICallBoth(hashedVector, uniqueVector3, uniqueVector4, false);
        AnalyzerUtilities.mergeVectors(uniqueVector, uniqueVector3, uniqueVector5);
        AnalyzerUtilities.mergeVectors(uniqueVector2, uniqueVector4, uniqueVector6);
    }

    public void setMethodsIImplement(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        HashedVector hashedVector2 = this.myClass.interfacesIExtendOrImplement;
        int n = 0;
        while (n < hashedVector2.size()) {
            MethodInfo methodInfo = this.methodOfSameNameIn((ClassInfo)hashedVector2.get(n));
            if (methodInfo != null) {
                uniqueVector.addElement(methodInfo.getCompleteDisplayName());
                uniqueVector2.addElement(methodInfo);
            }
            ++n;
        }
    }

    public void setMethodsIOverride(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        ClassInfo classInfo = this.myClass;
        while ((classInfo = classInfo.getSuperClass()) != null) {
            MethodInfo methodInfo = this.methodOfSameNameIn(classInfo);
            if (methodInfo == null) continue;
            uniqueVector.addElement(methodInfo.getCompleteDisplayName());
            uniqueVector2.addElement(methodInfo);
        }
    }

    public void setMethodsOverrideOrImplementMe(HashedVector hashedVector, UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        if (this.isInitializer()) {
            return;
        }
        this.buildOverrides();
        int n = this.methodsOverrideOrImplementMe.size();
        int n2 = 0;
        while (n2 < n) {
            uniqueVector.addElement(this.methodsOverrideOrImplementMe.elementAt(n2));
            uniqueVector2.addElement(((MethodInfo)this.methodsOverrideOrImplementMe.elementAt(n2)).getCompleteDisplayName());
            ++n2;
        }
    }

    public char[] uniqueName() {
        if (this.uniqueName == null) {
            String string = String.valueOf(this.myClass.rawName) + "." + this.rawName;
            this.uniqueName = string.toCharArray();
        }
        return this.uniqueName;
    }

    public String uniqueNameString() {
        return String.valueOf(this.myClass.rawName) + "." + this.rawName;
    }
}

