/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer.structures;

import java.io.IOException;
import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.ClassFileInputStream;
import org.apache.tools.analyzer.Decoder;
import org.apache.tools.analyzer.ExpandableArray;
import org.apache.tools.analyzer.info.ClassInfo;
import org.apache.tools.analyzer.info.MethodInfo;
import org.apache.tools.analyzer.structures.MACodeAttribute;
import org.apache.tools.analyzer.structures.MACodeAttributeLineTable;
import org.apache.tools.analyzer.structures.MACodeAttributeVariables;
import org.apache.tools.analyzer.structures.MACodeHandlerEntry;
import org.apache.tools.analyzer.structures.MAEntry;

public class MACodeEntry
extends MAEntry {
    private int maxStack;
    private int maxLocals;
    private int handlersCount;
    private int attributeCount;
    private MACodeAttribute[] codeAttributes;
    private MethodInfo methodInfo;
    public ClassInfo cInfo;
    public MACodeHandlerEntry[] handlers;
    public Decoder dc;
    public byte[] codeBuffer;
    public int codeCount;
    private static int currBytes;

    public ExpandableArray loadEntry(ClassFileInputStream classFileInputStream, ClassInfo classInfo, MethodInfo methodInfo, boolean bl) throws IOException {
        this.cInfo = classInfo;
        this.methodInfo = methodInfo;
        this.byteCount = classFileInputStream.getInt(4);
        this.maxStack = classFileInputStream.getInt(2);
        this.maxLocals = classFileInputStream.getInt(2);
        this.codeCount = classFileInputStream.getInt(4);
        this.codeBuffer = new byte[this.codeCount];
        int n = 0;
        while (n < this.codeCount) {
            this.codeBuffer[n] = classFileInputStream.readByte();
            ++n;
        }
        this.dc = new Decoder();
        ExpandableArray expandableArray = this.dc.decode(this.codeBuffer, this.codeCount, false);
        if (expandableArray == null) {
            AnalyzerUtilities.alert("Error decoding " + this.methodInfo.getCompleteDisplayName());
            return null;
        }
        this.handlersCount = classFileInputStream.getInt(2);
        if (this.handlersCount > 10000) {
            AnalyzerUtilities.p(String.valueOf(this.handlersCount) + " handlers");
        }
        this.handlers = new MACodeHandlerEntry[this.handlersCount];
        n = 0;
        while (n < this.handlersCount) {
            this.handlers[n] = new MACodeHandlerEntry();
            this.handlers[n].startPC = classFileInputStream.getInt(2);
            this.handlers[n].inactivePC = classFileInputStream.getInt(2);
            this.handlers[n].handlerPC = classFileInputStream.getInt(2);
            this.handlers[n].catchTypeIndex = classFileInputStream.getInt(2);
            ++n;
        }
        this.attributeCount = classFileInputStream.getInt(2);
        this.codeAttributes = new MACodeAttribute[this.attributeCount];
        n = 0;
        while (n < this.attributeCount) {
            int n2 = classFileInputStream.getInt(2);
            if ("LineNumberTable".equals(classInfo.readConstantPoolEntry(n2))) {
                this.codeAttributes[n] = new MACodeAttributeLineTable(classFileInputStream);
            } else if ("LocalVariableTable".equals(classInfo.readConstantPoolEntry(n2))) {
                this.codeAttributes[n] = new MACodeAttributeVariables(classFileInputStream);
            } else {
                AnalyzerUtilities.p("Decoder: Neither line number or variable");
            }
            ++n;
        }
        this.codeAttributes = null;
        if (!bl) {
            this.codeBuffer = null;
        }
        return expandableArray;
    }

    public int size() {
        return 50;
    }
}

