/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.tools.ant;

import java.io.*;
import java.util.*;

/** This is an ant task used to generate a build number.
*
* @author <a href="joeo@suninternet.com">Joseph B. Ottinger</a>
* @version 1.0.0
*/
public class Buildnumber extends Task
{
    /** the default property filename */
    protected String _propertyfile="build.properties";
    /** the default property name */
    protected String _property="build.number";
    /** the default directory to store the property file in */
    protected String _dir=".";
    /** Sets the property name
    * @param v the property name
    */
    public void setProperty(String v)
    {
        _property=v;
    }

    /** Sets the property file name
    * @param v the property file name
    */
    public void setPropertyfile(String v)
    {
        _propertyfile=v;
    }

    /** Sets the directory for the property file
    * @param v the directory name
    */
    public void setDir(String v)
    {
        _dir=v;
    }

    /**
    * Executes the ant task
    * @throws BuildException a build error has occurred
    */
    public void execute() throws BuildException
    {
        // load the properties from ${_dir}/${_propertyfile}
        Properties properties=new Properties();
        String propfilename=_dir+"/"+_propertyfile;
        try
        {
            FileInputStream fis=new FileInputStream(propfilename);
            properties.load(fis);

            fis.close();
        }
        catch (FileNotFoundException fnfe)
        {
            System.out.println("Creating new property file: "+propfilename);
        }
        catch (IOException ioe)
        {
            throw new BuildException(ioe.getMessage());
        }

        // okay, we gots properties! Now what?
        // we check the current ${build.number} value,
        // that's what.
        String strBuildNumber=properties.getProperty(_property);
        int build=0;
        try
        {
            build=Integer.parseInt(strBuildNumber);
        }
        catch (Exception e)
        {
            build=0;
        }
        build++;
        strBuildNumber=build+"";

        properties.setProperty(_property, strBuildNumber);
        project.setProperty(_property, strBuildNumber);
        log(_property+"="+strBuildNumber);
        try
        {
            FileOutputStream fos=new FileOutputStream(propfilename);
            properties.store(fos,"");
            fos.close();
        }
        catch (Exception e)
        {
            throw new BuildException(e.getMessage());
        }
    }
}
