package org.apache.tools.ant.gui.acs;

import org.apache.tools.ant.gui.xml.DOMElement;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport; 

/**
 * Abstract base class for all Ant Construction Set
 * elements. Depends on the JAXP XML library from Sun.
 * 
 * @version $Revision: 1.1 $ 
 * @author Simeon Fitch */
public abstract class ACSElement extends DOMElement {
    /** Name of the 'xmlString' property. */
    public static final String XML_STRING = "xmlString";

    /** Event support. */
    private PropertyChangeSupport _propSupport = null;

	/** 
	 * Default ctor.
	 * 
	 */
    protected ACSElement() {
    }

	/** 
	 * Get the display name of this.
	 * 
	 * @return Display name.
	 */
    public String getDisplayName() {
        return getTagName();
    }

	/** 
	 * Get the XML representation of this.
	 * 
	 * @return XML representation.
	 */
    public String getXMLString() {
        return toString();
    }

	/** 
	 * Set the given attribute.
	 * 
	 * @param name Name of the attribute.
	 * @param value Value of the attribute.
	 */
    public void setAttribute(String name, String value) {
        if(value == null && getAttribute(name).length() != 0) {
            removeAttribute(name);
        }
        else {
            super.setAttribute(name, value);
        }
    }

	/** 
	 * Add a change listener.
	 * 
	 * @param l Listener to add.
	 */
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if(_propSupport == null) {
            _propSupport = new PropertyChangeSupport(this);
        }
        _propSupport.addPropertyChangeListener(l);
    }


	/** 
	 * Remove a change listener
	 * 
	 * @param l Listener to remove.
	 */
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if(_propSupport == null) {
            _propSupport = new PropertyChangeSupport(this);
        }
        _propSupport.removePropertyChangeListener(l);
    }

	/** 
	 * Fire a change event to all listener.
	 * 
	 * @param propName Name of the property.
	 * @param oldValue The old value.
	 * @param newValue The new value.
	 */
    protected void firePropertyChange(
        String propName, Object oldValue, Object newValue) {
        
        if(_propSupport != null) {
            _propSupport.firePropertyChange(propName, oldValue, newValue);
        }
    }
}
