package org.apache.tools.ant.gui.acs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.IOException;
import java.io.File;

import java.net.URL;

import java.util.Enumeration;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.tools.ant.gui.xml.DOMDocument;
import org.apache.tools.ant.gui.xml.DOMNode;
import org.apache.tools.ant.gui.xml.DOMNodeManager;

import org.w3c.dom.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Text;

import org.xml.sax.SAXException;

/**
 * Factory for loading Ant Construction set elements.
 * 
 * @version $Revision: 1.1 $ 
 * @author Simeon Fitch 
 */
public class ACSFactory {
    /** Singleton instance of the factory. */
    private static ACSFactory _instance = null;

    /** Element maping. */
    private static final Properties _elementMap = new Properties();

    static {
        try {
            // First we bootstrap our knowledge of the Ant tasks by reading
            // in the taskdef definitions and assigning them the default
            // task element class.
            _elementMap.load(org.apache.tools.ant.taskdefs.Ant.class.
                          getResourceAsStream("defaults.properties"));
            Enumeration enum = _elementMap.propertyNames();
            while(enum.hasMoreElements()) {
                String name = (String) enum.nextElement();
                // XXX the name of the class needs to be stored externally.
                _elementMap.setProperty(
                    name, "org.apache.tools.ant.gui.acs.ACSDtdDefinedElement");
            }

            // Then we add/override the local definitions.
            _elementMap.load(ACSFactory.class.
                             getResourceAsStream("acs-element.properties"));
        }
        catch(Throwable ex) {
            // If something wrong happens here we can't do much more...
            ex.printStackTrace();
            System.exit(1);
        }
    }

	/** 
	 * Default ctor.
	 * 
	 */
    private ACSFactory() {

    }

	/** 
	 * Get an instance of the factory.
	 * 
	 * @return Factory instance.
	 */
    public static ACSFactory getInstance() {
        if(_instance == null) {
            _instance = new ACSFactory();
        }
        return _instance;
    }

	/** 
	 * Load a project from the given XML file.
     * XXX fix me.
	 * 
	 * @param location Location of the file.
	 * @return Loaded project.
	 */
    public ACSProjectElement load(File location) throws IOException {
        return load(new URL("file", null, location.getPath()));
    }

	/** 
	 * Load a project from the given XML file.
     * XXX fix me.
	 * 
	 * @param location Location of the file.
	 * @return Loaded project.
	 */
    public ACSProjectElement load(URL location) throws IOException {
        return load(location.openStream());
    }

	/** 
	 * Load a project from the given XML file.
     * XXX fix me.
	 * 
	 * @param location Location of the file.
	 * @return Loaded project.
	 */
    public ACSProjectElement load(InputStream stream) throws IOException {
        
        ACSProjectElement project = null;
        try {
            DOMNodeManager manager =
                new DOMNodeManager(_elementMap);
            
            DOMDocument doc = manager.parse(stream);
            project = (ACSProjectElement) doc.getDocumentElement();
            
        } catch (SAXException se) {
            se.printStackTrace();
            throw new IOException(se.getMessage());
        } catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new IOException(pce.getMessage());
        }            
        return project;
    }

    /** 
     * Create a new, empty project.
     * 
     * @return Empty project.
     */
    public ACSProjectElement createProject() {
        final String XMLDOC = 
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +
            "<project name=\"untitled\" />";
        try {
            return load(new ByteArrayInputStream(XMLDOC.getBytes()));
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }


    /** 
     * Create a new target.
     * 
     * @param project Project the target is assigned to.
     * @return New, unnamed target.
     */
    public ACSTargetElement createTarget(ACSProjectElement project) {
        ACSTargetElement retval = (ACSTargetElement) project.
            getOwnerDocument().createElement("target");
        indent(project, 1);
        project.appendChild(retval);
        return retval;
    }

    /** 
     * Create a new task.
     * 
     * @param target Target the task is assigned to.
     * @return New, unnamed task.
     */
    public ACSTaskElement createTask(ACSTargetElement target) {
        ACSTaskElement retval = (ACSTaskElement) target.
            getOwnerDocument().createElement("task");
        indent(target, 2);
        target.appendChild(retval);
        return retval;
    }

    /** 
     * Create a new property.
     * 
     * @param node the Node to assign the property to.
     * @return New, unnamed property.
     */
    public ACSPropertyElement createProperty(ACSElement node) {
        ACSPropertyElement retval = (ACSPropertyElement) node.
            getOwnerDocument().createElement("property");
        // XXX fixme.
        indent(node, 1);
        node.appendChild(retval);
        return retval;
    }

    /** 
     * Create a new element.
     * 
     * @param node the Node to assign the property to.
     * @param name the new elements type.
     * @return New, unnamed property.
     */
    public ACSElement createElement(ACSElement node, String name) {
        ACSElement retval = (ACSElement) node.
            getOwnerDocument().createElement(name);
        // XXX fixme.
        indent(node, 1);
        addRequiredAttributes(retval);
        node.appendChild(retval);
        return retval;
    }
    
    /** 
     * Add required attributes to the node.
     * 
     * @param node the Node to add the attrinutes to.
     */
    public void addRequiredAttributes(ACSElement node) {
        if (node instanceof ACSDtdDefinedElement) {
            ACSDtdDefinedElement dtdElement = 
                (ACSDtdDefinedElement) node;
            dtdElement.addRequiredAttributes();
        }
    }
    
    /** 
     * Insert a new line and indentation at the end of the given
     * node in preparation for a new element being added.
     * 
     * @param node Node to append indent to.
     * @param level Indentation level.
     */
    private void indent(ACSElement node, int level) {
        /*
        StringBuffer buf = new StringBuffer("\n");
        for(int i = 0; i < level; i++) {
            buf.append("    ");
        }

        Text text = node.getOwnerDocument().createTextNode(buf.toString());
        node.appendChild(text);
         */
    }


	/** 
	 * Test code
	 * 
	 * @param args  XML file to parse.
	 */
    public static void main(String[] args) {
        try {
            ACSFactory f = ACSFactory.getInstance();

            System.out.println(f.load(new File(args[0])));
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }
    }

}
