package org.apache.tools.ant.gui.acs;

import com.sun.xml.tree.ElementNode;
import java.util.StringTokenizer;

/**
 * Class representing an element with a name and description.
 * 
 * @version $Revision: 1.1 $ 
 * @author Simeon Fitch 
 */
public class ACSNamedElement extends ACSDtdDefinedElement {
    /** The 'name' property name. */
    public static final String NAME = "name";
    /** The discription property name. */
    public static final String DESCRIPTION = "description";

	/** 
	 * Default ctor.
	 * 
	 */
    public ACSNamedElement() {
    }

	/** 
	 * Get the target name.
	 * 
	 * @return Target name.
	 */
    public String getName() {
        return getAttribute(NAME);
    }

	/** 
	 * Set the name.
	 * 
	 * @param name New name value.
	 */
    public void setName(String name) {
        String old = getName();
        setAttribute(NAME, name);
        firePropertyChange(NAME, old, name);
    }

	/** 
	 * Get the long description of the target.
	 * 
	 * @return Target description.
	 */
    public String getDescription() {
        return getAttribute(DESCRIPTION);
    }

	/** 
	 * Set the description
	 * 
	 * @param description New description value.
	 */
    public void setDescription(String description) {
        String old = getDescription();
        setAttribute(DESCRIPTION, description);
        firePropertyChange(DESCRIPTION, old, description);
    }

	/** 
	 * Get the display name.
	 * 
	 * @return Display name.
	 */
    public String getDisplayName() {
        return getName();
    }

}
