
package org.apache.tools.ant.gui.xml;

import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.ProcessingInstruction;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;

public class DOMNode
{
    private Node _impl;
    private DOMNodeFactory _factory;

    public DOMNode() {
    }
    public DOMNodeFactory getFactory() {
        return _factory;
    }
    void setFactory(DOMNodeFactory factory) {
        _factory = factory;
    }
    public void setImpl(Node impl) {
        _impl = impl;
    }
    public Node getImpl() {
        return _impl;
    }
    public void write(Writer writer) throws SAXException {
        DOMNodeSerializer serializer = new DOMNodeSerializer(_factory);
        serializer.write(this, writer);
    }
    
    public String toString() {
        DOMNodeSerializer serializer = new DOMNodeSerializer(_factory);
        CharArrayWriter w = new CharArrayWriter();
        try {
            serializer.write(this, w);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return w.toString();
    }
    
    //
    // 
    //
    
    public String getNodeName() {
        return _impl.getNodeName();
    }
    public void setNodeValue (String value) throws DOMException {
        _impl.setNodeValue (value);
    }
    public String getNodeValue () throws DOMException {
        return _impl.getNodeValue();
    }
    public short getNodeType () {
        return _impl.getNodeType ();
    }
    public DOMNode getParentNode () {
        return _factory.createDOMNode( _impl.getParentNode () );
    }
    public DOMNodeList getChildNodes () {
        return new DOMNodeList( _factory, _impl.getChildNodes() );
    }
    public DOMNode getFirstChild () {
        return _factory.createDOMNode( _impl.getFirstChild () );
    }
    public DOMNode getLastChild () {
        return _factory.createDOMNode( _impl.getLastChild () );
    }
    public DOMNode replaceChild (DOMNode newChild, DOMNode oldChild)
            throws DOMException {
        return _factory.createDOMNode(
            _impl.replaceChild (newChild.getImpl(),
            oldChild.getImpl()) );
    }
    public DOMNode removeChild (DOMNode oldChild) throws DOMException {
        return _factory.createDOMNode( _impl.removeChild (
            oldChild.getImpl()) );
    }
    public DOMNode insertBefore (DOMNode newChild, DOMNode refChild)
            throws DOMException {
        return _factory.createDOMNode(
            _impl.insertBefore (newChild.getImpl(),
            refChild.getImpl()) );
    }
    public DOMNode appendChild (DOMNode newChild) throws DOMException {
        return _factory.createDOMNode(
            _impl.appendChild (newChild.getImpl()) ); 
    }
    public boolean hasChildNodes () {
        return _impl.hasChildNodes ();
    }
    public DOMNode getPreviousSibling () {
        return _factory.createDOMNode( _impl.getPreviousSibling() );
    }
    public DOMNode getNextSibling () {
        return _factory.createDOMNode( _impl.getNextSibling() );
    }
    public NamedDOMNodeMap getAttributes () {
        return new NamedDOMNodeMap( _factory, _impl.getAttributes() );
    }
    public boolean hasAttributes() {
        return (_impl.getAttributes().getLength() > 0);
    }
    public String getNamespaceURI() {
        return _impl.getNamespaceURI();
    }
    public String getPrefix() {
        return _impl.getPrefix();
    }
    public void setPrefix(String prefix) throws DOMException {
        _impl.setPrefix(prefix);
    }
    public String getLocalName() {
        return _impl.getLocalName();
    }
    public DOMNode cloneNode (boolean deep) {
        return _factory.createDOMNode( _impl.cloneNode (deep) );
    }
    public void normalize() {
        _impl.normalize();
    }
    public DOMDocument getOwnerDocument() {
        return _factory.createDOMDocument(_impl.getOwnerDocument());
    }
}
