
package org.apache.tools.ant.gui.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

class DOMNodeFinder {

    private Map _map = new HashMap();
    private Map _docMap = new HashMap();
    
    /** Creates new ProxyFinder */
    public DOMNodeFinder() {
    }

    public void assign(Node impl, DOMNode node) {
        _map.put(impl , node);
    }
    
    public void assign(Document impl, DOMDocument doc) {
        _docMap.put(impl , doc);
    }
    
    public DOMNode find(Node impl) {
        return (DOMNode) _map.get(impl);
    }
    
    public DOMDocument find(Document impl) {
        return (DOMDocument) _docMap.get(impl);
    }
    
    public List find(List list) {
        ArrayList result = new ArrayList();
        for(int i = 0; i < list.size(); i++) {
            DOMNode p = (DOMNode) _map.get(list.get(i) );
            if (p != null) {
                result.add(p);
            }
        }
        return result;
    }
}
