
package org.apache.tools.ant.gui.xml;

import java.io.InputStream;
import java.io.IOException;

import java.util.List;
import java.util.Map;

import java.lang.reflect.Constructor;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.xml.sax.SAXException;

public class DOMNodeManager implements DOMNodeContainer, DOMNodeFactory {

    private DOMNodeFinder _nodeFinder = new DOMNodeFinder();
    private Map _nodeToClass;
    
    public DOMNodeManager(Map nodeToClass) {
        if (nodeToClass == null) {
            throw new IllegalArgumentException(
                "Map can not be null");
        }
        _nodeToClass = nodeToClass;
    }

    public DOMDocument parse(InputStream stream) 
            throws SAXException, ParserConfigurationException, IOException {
                
        DocumentBuilder builder;
        DocumentBuilderFactory factory =
            DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        
        builder = factory.newDocumentBuilder();
        Document doc = builder.parse(stream);

        DOMDocument domDoc = createDOMDocument(doc);
        Node node = doc.getDocumentElement();
        DOMNode domNode = createDOMNode(node);
        createAllChildren(domNode);
        return domDoc;
    }

    DOMNodeFinder getNodeFinder() {
        return _nodeFinder;
    }
    
    public void createAllChildren(DOMNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node can not be a null");
        }
        TreeWalker i = new TreeWalker(node.getImpl());
        Node real = i.getCurrent();
        while(real != null) {
            createDOMNode(real);
            real = i.getNext();
        }
    }
    
    public DOMDocument createDOMDocument(Document impl) {
        if (impl == null) {
            return null;
        }
        
        DOMDocument doc = find(impl);
        if (doc != null) {
            return doc;
        }

        doc = new DOMDocument();
        doc.setImpl(impl);
        _nodeFinder.assign(impl, doc);
        doc.setFactory(this);
        doc.setContainer(this);
        return doc;
    }
    
    public DOMNode createDOMNode(Node impl) {
        if (impl == null) {
            return null;
        }
        
        DOMNode node = find(impl);
        if (node != null) {
            return node;
        }
        
        String name = impl.getNodeName();
        String className = (String) _nodeToClass.get(name);
        if (className == null && impl instanceof Element) {
            className = (String) _nodeToClass.get("*Element");
        }
        if (className == null) {
            className = (String) _nodeToClass.get("*Node");
            if (className == null) {
                return null;
            }
        }
        try {
            Class theClass = Class.forName (className);
            if (theClass == null) {
                return null;
            }
            node = (DOMNode) theClass.newInstance();
            node.setImpl(impl);
            _nodeFinder.assign(impl, node);
            node.setFactory(this);
        } catch (Exception e) {
            e.printStackTrace();
            node = null;
        }
        return node;
    }
    
    public void assign(Node real, DOMNode proxy) {
        _nodeFinder.assign(real, proxy);
    }
    
    public DOMNode find(Node impl) {
        return _nodeFinder.find(impl);
    }
    
    public DOMDocument find(Document impl) {
        return _nodeFinder.find(impl);
    }
    
    public List find(List list) {
        return _nodeFinder.find(list);
    }
}
