
package org.apache.tools.ant.gui.xml;

import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import org.xml.sax.Attributes;

import org.xml.sax.helpers.AttributesImpl;

public class NamedDOMNodeMap  {

    private NamedNodeMap _impl;
    private DOMNodeFactory _factory;
    
    /** Creates new NamedNodeMap */
    public NamedDOMNodeMap(DOMNodeFactory factory, NamedNodeMap map) {
        _impl = map;
        _factory = factory;
    }

    public Attributes convertToAttributes() {
        AttributesImpl attrs = new AttributesImpl();
        if (_impl == null) {
            return attrs;
        }
        
        for (int i = 0; i < getLength(); i++) {
            Node n = _impl.item(i);
        
            String uri = (n.getNamespaceURI() == null) ? "" :
                n.getNamespaceURI();

            String localname = (n.getLocalName() == null) ? "" :
                n.getLocalName();

            String prefix = (n.getPrefix() == null) ? "" :
                n.getPrefix();

            String value = (n.getNodeValue() == null) ? "" :
                n.getNodeValue();
            
            attrs.addAttribute (uri, localname, prefix, "CDATA", value);
        }
        return attrs;
    }
    
    public DOMNode setNamedItem(DOMNode node) throws DOMException {
        Node temp = _impl.setNamedItem(node.getImpl());
        return _factory.createDOMNode(temp);
    }
    
    public DOMNode getNamedItem(String name) {
        Node node = _impl.getNamedItem(name);
        return _factory.createDOMNode(node);
    }
    
    public int getLength() {
        return _impl.getLength();
    }
    
    public DOMNode item(int index) {
        Node node = _impl.item(index);
        return _factory.createDOMNode(node);
    }
    
    public DOMNode removeNamedItem(String name) throws DOMException {
        Node node = _impl.removeNamedItem(name);
        return _factory.createDOMNode(node);
    }
}
