    protected void checkAndAddDependants(Hashtable checkEntries)
	throws BuildException
    {
	Dependencies visitor = new Dependencies();
	Set set = new TreeSet();
	Set newSet = new HashSet();
	final String base = config.srcDir.getAbsolutePath() + File.separator;

	Iterator i = checkEntries.keySet().iterator();
	while (i.hasNext()) {
	    String entryName = (String)i.next();
	    if (entryName.endsWith(".class"))
		newSet.add(entryName.substring(0, entryName.length() - ".class".length()).replace(File.separatorChar, '/'));
	}
	set.addAll(newSet);

	do {
	    i = newSet.iterator();
	    while (i.hasNext()) {
		String fileName = base + ((String)i.next()).replace('/', File.separatorChar) + ".class";

		try {
		    JavaClass javaClass = new ClassParser(fileName).parse();
		    javaClass.accept(visitor);
		}
		catch (IOException e) {
		    log("exception: " +  e.getMessage(), Project.MSG_INFO);
		}
	    }
	    newSet.clear();
	    newSet.addAll(visitor.getDependencies());
	    visitor.clearDependencies();

	    Dependencies.applyFilter(newSet, new Filter() {
		    public boolean accept(Object object) {
			String fileName = base + ((String)object).replace('/', File.separatorChar) + ".class";
			return new File(fileName).exists();
		    }
		});
	    newSet.removeAll(set);
	    set.addAll(newSet);
	}
	while (newSet.size() > 0);

	i = set.iterator();
	while (i.hasNext()) {
	    String next = ((String)i.next()).replace('/', File.separatorChar);
	    checkEntries.put(next + ".class", new File(base + next + ".class"));
	    log("dependent class: " + next + ".class" + " - " + base + next + ".class", Project.MSG_INFO);
	}
    }
