/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantCP;
import de.fub.bytecode.classfile.ConstantClass;
import de.fub.bytecode.classfile.ConstantDouble;
import de.fub.bytecode.classfile.ConstantFloat;
import de.fub.bytecode.classfile.ConstantInteger;
import de.fub.bytecode.classfile.ConstantLong;
import de.fub.bytecode.classfile.ConstantNameAndType;
import de.fub.bytecode.classfile.ConstantString;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.Node;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ConstantPool
implements Cloneable,
Node {
    private int constant_pool_count;
    private Constant[] constant_pool;

    public ConstantPool(Constant[] constantArray) {
        this.setConstantPool(constantArray);
    }

    ConstantPool(DataInputStream dataInputStream) throws IOException, ClassFormatError {
        this.constant_pool_count = dataInputStream.readUnsignedShort();
        this.constant_pool = new Constant[this.constant_pool_count];
        int n = 1;
        while (n < this.constant_pool_count) {
            this.constant_pool[n] = Constant.readConstant(dataInputStream);
            byte by = this.constant_pool[n].getTag();
            if (by == 6 || by == 5) {
                ++n;
            }
            ++n;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantPool(this);
    }

    public String constantToString(Constant constant) throws ClassFormatError {
        String string;
        byte by = constant.getTag();
        switch (by) {
            case 7: {
                int n = ((ConstantClass)constant).getNameIndex();
                constant = this.getConstant(n, (byte)1);
                string = Utility.compactClassName(((ConstantUtf8)constant).getBytes(), false);
                break;
            }
            case 8: {
                int n = ((ConstantString)constant).getStringIndex();
                constant = this.getConstant(n, (byte)1);
                string = "\"" + ConstantPool.escape(((ConstantUtf8)constant).getBytes()) + "\"";
                break;
            }
            case 1: {
                string = ((ConstantUtf8)constant).getBytes();
                break;
            }
            case 6: {
                string = "" + ((ConstantDouble)constant).getBytes();
                break;
            }
            case 4: {
                string = "" + ((ConstantFloat)constant).getBytes();
                break;
            }
            case 5: {
                string = "" + ((ConstantLong)constant).getBytes();
                break;
            }
            case 3: {
                string = "" + ((ConstantInteger)constant).getBytes();
                break;
            }
            case 12: {
                string = this.constantToString(((ConstantNameAndType)constant).getNameIndex(), (byte)1) + " " + this.constantToString(((ConstantNameAndType)constant).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string = this.constantToString(((ConstantCP)constant).getClassIndex(), (byte)7) + "." + this.constantToString(((ConstantCP)constant).getNameAndTypeIndex(), (byte)12);
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + by);
            }
        }
        return string;
    }

    private static final String escape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 5);
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < n) {
            switch (cArray[n2]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n2]);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String constantToString(int n, byte by) throws ClassFormatError {
        Constant constant = this.getConstant(n, by);
        return this.constantToString(constant);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.constant_pool_count);
        int n = 1;
        while (n < this.constant_pool_count) {
            if (this.constant_pool[n] != null) {
                this.constant_pool[n].dump(dataOutputStream);
            }
            ++n;
        }
    }

    public Constant getConstant(int n) {
        if (n >= this.constant_pool.length || n < 0) {
            throw new ClassFormatError("Invalid constant pool reference: " + n + ". Constant pool size is: " + this.constant_pool.length);
        }
        return this.constant_pool[n];
    }

    public Constant getConstant(int n, byte by) throws ClassFormatError {
        Constant constant = this.getConstant(n);
        if (constant == null) {
            throw new ClassFormatError("Constant pool at index " + n + " is null.");
        }
        if (constant.getTag() == by) {
            return constant;
        }
        throw new ClassFormatError("Expected class `" + Constants.CONSTANT_NAMES[by] + "' at index " + n + " and got " + constant);
    }

    public Constant[] getConstantPool() {
        return this.constant_pool;
    }

    public String getConstantString(int n, byte by) throws ClassFormatError {
        int n2;
        Constant constant = this.getConstant(n, by);
        switch (by) {
            case 7: {
                n2 = ((ConstantClass)constant).getNameIndex();
                break;
            }
            case 8: {
                n2 = ((ConstantString)constant).getStringIndex();
                break;
            }
            default: {
                throw new RuntimeException("getConstantString called with illegal tag " + by);
            }
        }
        constant = this.getConstant(n2, (byte)1);
        return ((ConstantUtf8)constant).getBytes();
    }

    public int getLength() {
        return this.constant_pool_count;
    }

    public void setConstant(int n, Constant constant) {
        this.constant_pool[n] = constant;
    }

    public void setConstantPool(Constant[] constantArray) {
        this.constant_pool = constantArray;
        this.constant_pool_count = constantArray == null ? 0 : constantArray.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (n < this.constant_pool_count) {
            stringBuffer.append(n + ")" + this.constant_pool[n] + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public ConstantPool copy() {
        ConstantPool constantPool = null;
        try {
            constantPool = (ConstantPool)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        constantPool.constant_pool = new Constant[this.constant_pool_count];
        int n = 1;
        while (n < this.constant_pool_count) {
            if (this.constant_pool[n] != null) {
                constantPool.constant_pool[n] = this.constant_pool[n].copy();
            }
            ++n;
        }
        return constantPool;
    }
}

