/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.Code;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.ExceptionTable;
import de.fub.bytecode.classfile.FieldOrMethod;
import de.fub.bytecode.classfile.LineNumberTable;
import de.fub.bytecode.classfile.LocalVariableTable;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.IOException;

public final class Method
extends FieldOrMethod {
    public Method() {
    }

    public Method(Method method) {
        super(method);
    }

    Method(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException, ClassFormatError {
        super(dataInputStream, constantPool);
    }

    public Method(int n, int n2, int n3, Attribute[] attributeArray, ConstantPool constantPool) {
        super(n, n2, n3, attributeArray, constantPool);
    }

    public void accept(Visitor visitor) {
        visitor.visitMethod(this);
    }

    public final Code getCode() {
        int n = 0;
        while (n < this.attributes_count) {
            if (this.attributes[n] instanceof Code) {
                return (Code)this.attributes[n];
            }
            ++n;
        }
        return null;
    }

    public final ExceptionTable getExceptionTable() {
        int n = 0;
        while (n < this.attributes_count) {
            if (this.attributes[n] instanceof ExceptionTable) {
                return (ExceptionTable)this.attributes[n];
            }
            ++n;
        }
        return null;
    }

    public final LocalVariableTable getLocalVariableTable() {
        Code code = this.getCode();
        if (code != null) {
            return code.getLocalVariableTable();
        }
        return null;
    }

    public final LineNumberTable getLineNumberTable() {
        Code code = this.getCode();
        if (code != null) {
            return code.getLineNumberTable();
        }
        return null;
    }

    public final String toString() {
        String string;
        Attribute attribute;
        String string2 = Utility.accessToString(this.access_flags);
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        String string3 = constantUtf8.getBytes();
        constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        String string4 = constantUtf8.getBytes();
        string3 = Utility.methodSignatureToString(string3, string4, string2, true, this.getLocalVariableTable());
        StringBuffer stringBuffer = new StringBuffer(string3);
        int n = 0;
        while (n < this.attributes_count) {
            attribute = this.attributes[n];
            if (!(attribute instanceof Code) && !(attribute instanceof ExceptionTable)) {
                stringBuffer.append(" [" + attribute.toString() + "]");
            }
            ++n;
        }
        attribute = this.getExceptionTable();
        if (attribute != null && !(string = ((ExceptionTable)attribute).toString()).equals("")) {
            stringBuffer.append("\n\t\tthrows " + string);
        }
        return stringBuffer.toString();
    }

    public final Method copy(ConstantPool constantPool) {
        return (Method)this.copy_(constantPool);
    }
}

