/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.StackMapType;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMapEntry
implements Cloneable {
    private int byte_code_offset;
    private int number_of_locals;
    private StackMapType[] types_of_locals;
    private int number_of_stack_items;
    private StackMapType[] types_of_stack_items;
    private ConstantPool constant_pool;

    StackMapEntry(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(dataInputStream.readShort(), dataInputStream.readShort(), null, -1, null, constantPool);
        this.types_of_locals = new StackMapType[this.number_of_locals];
        int n = 0;
        while (n < this.number_of_locals) {
            this.types_of_locals[n] = new StackMapType(dataInputStream, constantPool);
            ++n;
        }
        this.number_of_stack_items = dataInputStream.readShort();
        this.types_of_stack_items = new StackMapType[this.number_of_stack_items];
        int n2 = 0;
        while (n2 < this.number_of_stack_items) {
            this.types_of_stack_items[n2] = new StackMapType(dataInputStream, constantPool);
            ++n2;
        }
    }

    public StackMapEntry(int n, int n2, StackMapType[] stackMapTypeArray, int n3, StackMapType[] stackMapTypeArray2, ConstantPool constantPool) {
        this.byte_code_offset = n;
        this.number_of_locals = n2;
        this.types_of_locals = stackMapTypeArray;
        this.number_of_stack_items = n3;
        this.types_of_stack_items = stackMapTypeArray2;
        this.constant_pool = constantPool;
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.byte_code_offset);
        dataOutputStream.writeShort(this.number_of_locals);
        int n = 0;
        while (n < this.number_of_locals) {
            this.types_of_locals[n].dump(dataOutputStream);
            ++n;
        }
        dataOutputStream.writeShort(this.number_of_stack_items);
        int n2 = 0;
        while (n2 < this.number_of_stack_items) {
            this.types_of_stack_items[n2].dump(dataOutputStream);
            ++n2;
        }
    }

    public final String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("(offset=" + this.byte_code_offset);
        if (this.number_of_locals > 0) {
            stringBuffer.append(", locals={");
            n = 0;
            while (n < this.number_of_locals) {
                stringBuffer.append(this.types_of_locals[n]);
                if (n < this.number_of_locals - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            stringBuffer.append("}");
        }
        if (this.number_of_stack_items > 0) {
            stringBuffer.append(", stack items={");
            n = 0;
            while (n < this.number_of_stack_items) {
                stringBuffer.append(this.types_of_stack_items[n]);
                if (n < this.number_of_stack_items - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void setByteCodeOffset(int n) {
        this.byte_code_offset = n;
    }

    public int getByteCodeOffset() {
        return this.byte_code_offset;
    }

    public void setNumberOfLocals(int n) {
        this.number_of_locals = n;
    }

    public int getNumberOfLocals() {
        return this.number_of_locals;
    }

    public void setTypesOfLocals(StackMapType[] stackMapTypeArray) {
        this.types_of_locals = stackMapTypeArray;
    }

    public StackMapType[] getTypesOfLocals() {
        return this.types_of_locals;
    }

    public void setNumberOfStackItems(int n) {
        this.number_of_stack_items = n;
    }

    public int getNumberOfStackItems() {
        return this.number_of_stack_items;
    }

    public void setTypesOfStackItems(StackMapType[] stackMapTypeArray) {
        this.types_of_stack_items = stackMapTypeArray;
    }

    public StackMapType[] getTypesOfStackItems() {
        return this.types_of_stack_items;
    }

    public StackMapEntry copy() {
        try {
            return (StackMapEntry)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitStackMapEntry(this);
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }
}

