package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.optional.dotnet.CSharp;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;

// ====================================================================
/**
This task compiles Visual Basic.NET source into executables or modules.
The task will only work on win2K until other platforms support vbc.exe or 
an equivalent. VBC.exe must be on the execute path, too.

<p>
All parameters are optional: &lt;vbc/&gt; should suffice to produce a debug
build of all *.vb files.

@author Brian Felder bfelder@providence.org
*/

public class VisualBasicCompile extends CSharp {

	/**
	 * Constructor for VisualBasicCompile.
	 */
	public VisualBasicCompile() {
        Clear();
        setIncludes(vb_file_pattern);
    }
	 
    private File srcDir;
    
    /**
	 * Name of the VBC compiler executable.
    */
    protected static final String vb_exe_name="vbc";
    
    /**
	 * File extension for VB files
    */
    protected static final String vb_file_ext="vb";
    
    /**
	 * Search pattern for VB files.
    */
    protected static final String vb_file_pattern="**/*." + vb_file_ext;
	 
	 /**
	 * We need to override the execute method from CSharp, because vbc does not
	 * support the same options as csc.
	 */
    public void execute() 
        throws BuildException {
        if (getSrcDir() == null)
            srcDir = project.resolveFile(".");
    
        NetCommand command=new NetCommand(this,"VBC",vb_exe_name);
        command.setFailOnError(getFailOnError());
        //DEBUG helper
        command.setTraceCommandLine(true);
        //fill in args
        command.addArgument("/nologo");
        command.addArgument(getAdditionalModulesParameter());
        command.addArgument(getDefinitionsParameter());
        command.addArgument(getDebugParameter());
        // command.addArgument(getDocFileParameter());
        // command.addArgument(getIncrementalParameter());
        command.addArgument(getMainClassParameter());
        command.addArgument(getOptimizeParameter());
        command.addArgument(getReferencesParameter());
        command.addArgument(getTargetTypeParameter());
        command.addArgument(getUnsafeParameter());
        // command.addArgument(getWarnLevelParameter());
        command.addArgument(getWin32IconParameter());
        command.addArgument(getOutputFileParameter());   
        // command.addArgument(getIncludeDefaultReferencesParameter());
        command.addArgument(getDefaultReferenceParameter());
        command.addArgument(getWin32ResParameter());
        command.addArgument(getUtf8OutputParameter());
        command.addArgument(getNoConfigParameter());
        // command.addArgument(getFullPathsParameter());
        command.addArgument(getExtraOptionsParameter());
        
        //get dependencies list. 
        DirectoryScanner scanner = super.getDirectoryScanner(srcDir);
        String[] dependencies = scanner.getIncludedFiles();
        log("compiling "+dependencies.length+" file"+((dependencies.length==1)?"":"s"));
        String baseDir=scanner.getBasedir().toString();
        //add to the command
        for (int i = 0; i < dependencies.length; i++) {
            String targetFile=dependencies[i];
            targetFile=baseDir+File.separator+targetFile;
            command.addArgument(targetFile);
        }
        
        //now run the command of exe + settings + files
        command.runCommand();
    } // end execute

    /** 
    * VB Reference inclusions. The VB compiler looks for these to be
	 * comma-separated, rather than semicolon-separated (as in CSharp).
    */
    protected static final String DEFAULT_REFERENCE_LIST=
            "Accessibility.dll,"+
            "cscompmgd.dll,"+
            "CustomMarshalers.dll,"+
            "IEExecRemote.dll,"+
            "IEHost.dll,"+
            "IIEHost.dll,"+
            "ISymWrapper.dll,"+
            "Microsoft.JScript.dll,"+
            "Microsoft.VisualBasic.dll,"+
            "Microsoft.VisualC.dll,"+
            "Microsoft.Vsa.dll,"+
            "Mscorcfg.dll,"+
            "RegCode.dll,"+
            "System.Configuration.Install.dll,"+
            "System.Data.dll,"+
            "System.Design.dll,"+
            "System.DirectoryServices.dll,"+
            "System.EnterpriseServices.dll,"+
            "System.dll,"+
            "System.Drawing.Design.dll,"+
            "System.Drawing.dll,"+
            "System.Management.dll,"+
            "System.Messaging.dll,"+
            "System.Runtime.Remoting.dll,"+
            "System.Runtime.Serialization.Formatters.Soap.dll,"+
            "System.Security.dll,"+
            "System.ServiceProcess.dll,"+
            "System.Web.dll,"+
            "System.Web.RegularExpressions.dll,"+
            "System.Web.Services.dll,"+
            "System.Windows.Forms.dll,"+
            "System.XML.dll,";


         
    /** 
    * This method overridden because it uses the DEFAULT_REFERENCES_LIST.
    */ 
    protected String getDefaultReferenceParameter() {
        if(getIncludeDefaultReferences()) {
            StringBuffer s=new StringBuffer("/reference:");
            s.append(DEFAULT_REFERENCE_LIST);
            return new String(s);
        }
        else
            return null;            
    }
    
	 /**
	 * Overridden because we need to be able to set the _srcDir.
    */
    public File getSrcDir() {
        return srcDir;
    }

    /**
    * Sets the srcDir.
    */
    public void setSrcDir(File aSrcDir) {
        this.srcDir = aSrcDir;
    }
}


