/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.tools.ant.taskdefs.optional.genjar;

import java.io.*;
import java.util.*;
import java.util.jar.*;
import java.util.zip.*;
import org.apache.tools.ant.*;
import org.apache.tools.ant.types.*;
/**
 * <p>Represents a &lt;class&gt; element.<p>
 * Buildfile example:<pre>
 *   &lt;class name="com.riggshill.ant.genjar.GenJar"/&gt;
 *   &lt;class name="com.riggshill.xml.Editor" bean="yes"/&gt;
 * </pre>
 * <p>
 *   When the &lt;class&gt; element is encountered, a new ClassSpec
 *   is instantiated to represent that element.  The class is used
 *   hold the class' name and manifest information.
 * </p>
 * <p>
 *   The <code>resolve()</code> method is implemented to determine which
 *   classes <i>this</i> class is dependant upon.  A list of these classes
 *   is held for later inclusion into the jar.
 * </p>
 *
 * @author Original Code: <a href="mailto:jake@riggshill.com">John W. Kohler</a>
 * @version @version@
 */
public class ClassSpec extends JarSpec
{
		/**
		 * name of class
		 */
	private String name = null;
		/** if set, this class is to be marked as a bean in the manifest */
	private boolean bean = false;
		/** list of all dependant classes */
	private List jarEntries = new ArrayList();
		/**
		 * Returns the list of classes upon which this class
		 * is dependant.
		 * @return the list of all dependant classes
		 */
	public List getJarEntries()
	{
		return jarEntries;
	}
		/**
		 * Invoked by Ant when the <code>name</code> attribute is encountered.
		 * If the value is <code>yes</code> or <code>true</code> then this
		 * class' manifest entry will be marked as a java bean:
		 * <code>Java-Bean: true</code>
		 */
	public void setBean( String v )
	{
		if ( "yes".equalsIgnoreCase( v ) ||
			 "true".equalsIgnoreCase( v ) )
			bean = true;
		else
			bean = false;
		
			//
			// if the 'bean' attribute is AFTER the name
			// attribute then we've gotta dig the
			// jarEntrySpec outta the collection
			//
		if ( jarEntries.size() > 0 ) 
			for ( Iterator it = jarEntries.iterator(); it.hasNext(); )
				((JarEntrySpec)it.next()).setAttribute( "Java-Bean",
														bean? "true" : "false" );
	}
		/**
		 *  Invoked by Ant when the <code>name</code> attribute is encountered.
		 */
	public void setName( String n )
	{		
		name = n.replace( '.', '/' ) + ".class";
		JarEntrySpec jes = new JarEntrySpec( name, null );
		
		if ( bean ) 
			jes.setAttribute( "Java-Bean", "true" );
		jarEntries.add( jes );
	}
		/**
		 * Generates a list of all classes upon which this class is dependant.
		 */
	public void resolve( GenJar gj )
		throws IOException
	{
		gj.generateDependancies( jarEntries );
	}
}
