/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.tools.ant.taskdefs.optional.genjar;

import java.io.*;
import java.util.*;
import java.util.jar.*;
import java.util.zip.*;
/**
 * Represents one object (file) that is to be placed into the jar.<p>
 * This includes all &lt;class&gt; names specified in the project file, all
 * &lt;resource&gt; files specified in the project file and all generated
 * class references.<p>
 * 
 * @author Original Code: <a href="mailto:jake@riggshill.com">John W. Kohler</a>
 * @version @version@
 */
public class JarEntrySpec
{
	Attributes atts;
	String     jarName;
	File       srcFile;



	JarEntrySpec()
	{
		atts = new Attributes();
	}

		/**
		 * create a nrew jar entry given a name (jar path) and a fully
		 * qualified file path
		 */
	JarEntrySpec( String jarName, File srcFile )
	{
		this.jarName = jarName.replace( '\\', '/' );
		this.srcFile = srcFile;
		atts = new Attributes();

		if ( srcFile != null ) {
			setAttribute( "Content-Location", srcFile.getAbsolutePath() );
			setAttribute( "Content-Length", srcFile.length() );
			setAttribute( "Last-Modified", new Date( srcFile.lastModified() ) );
		}
	}
		
	String getJarName()
	{
		return jarName;
	}

	void setJarName( String jn )
	{
		jarName = jn;
	}

	File getSourceFile()
	{
		return srcFile;
	}

	void setSourceFile( File f )
	{
		srcFile = f;
	}

	Attributes getAttributes()
	{
		return atts;
	}

		/**
		 * copy an Attributes into this entry's attributs
		 */
	public void addAttributes( Attributes a )
	{
		if ( a != null ) {
			for ( Iterator it = a.keySet().iterator(); it.hasNext(); ) {
				String key = it.next().toString();
				atts.putValue( key, a.getValue( key ) );
			}
		}
	}
	

	void setAttribute( String name, int val )
	{
		setAttribute( name, Integer.toString( val ) );
	}

	void setAttribute( String name, long val )
	{
		setAttribute( name, Long.toString( val ) );
	}

	void setAttribute( String name, float val )
	{
		setAttribute( name, Float.toString( val ) );
	}

	void setAttribute( String name, double val )
	{
		setAttribute( name, Double.toString( val ) );
	}
	
	void setAttribute( String name, Date d )
	{
		atts.putValue( name, d.toString() );
	}

	void setAttribute( String name, Object obj )
	{
		atts.putValue( name, obj.toString() );
	}

	public String toString()
	{
		String key;
		StringBuffer sb = new StringBuffer( "JarEntrySpec:" );

		sb.append( "\n\tJar Name:" );
		sb.append( jarName );
		sb.append( "\n\tStream  :" );
		if ( srcFile == null )
			sb.append( "** NOT RESOLVED **" );
		else
			sb.append( srcFile.getAbsolutePath() );

		for ( Iterator it = atts.keySet().iterator(); it.hasNext(); ) {
			sb.append( "\n\tAtt: " );
			sb.append( key = it.next().toString() );
			sb.append( ": " );
			sb.append( atts.getValue( key ) );
		}
		return sb.toString();
	}
}

