﻿/*
 * [The "BSD licence"]
 * Copyright (c) 2005-2008 Terence Parr
 * All rights reserved.
 *
 * Conversion to C#:
 * Copyright (c) 2008-2009 Sam Harwell, Pixel Mine, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

namespace Antlr.Runtime
{
    /// <summary>
    /// Controls the behavior of lower priority, lower cardinality operator next to higher priority,
    /// higher cardinality operator.
    /// </summary>
    /// <example>
    /// In languages like Matlab, the unary +/- operators have a lower priority than the binary
    /// exponentiation operator. The user needs to be able to configure the handling of the unary
    /// +/- operators in the following case:
    ///
    ///   2^-2
    ///
    /// If the unary operator's precedence remains lower than the exponentiation operator, this
    /// is syntactically incorrect. As an option, and one that Matlab uses, the operator's
    /// precedence immediately following an exponentiation operator is elevated, so the expression
    /// above is allowed.
    /// </example>
    public enum MixedCardinalityAction
    {
        /// <summary>
        /// Never re-order the operator precedence of the lower priority operator to allow its
        /// use next to a higher priority operator.
        /// </summary>
        None,
        /// <summary>
        /// When syntactically unambiguous, elevates the lower cardinality operator's precedence
        /// to allow its usage next to a higher cardinality operator.
        /// </summary>
        Elevate
    }
}
