/*
 * [The "BSD licence"]
 * Copyright (c) 2005-2008 Terence Parr
 * All rights reserved.
 *
 * Conversion to C#:
 * Copyright (c) 2008-2009 Sam Harwell, Pixel Mine, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

namespace Antlr3.Runtime.Test.OperatorParser
{
    using Antlr.Runtime;
    using Antlr.Runtime.Tree;
    using System.Collections.Generic;

    partial class SubCParser
    {
        static readonly PrecedenceTreeCreator Precedence =
            new PrecedenceTreeCreator(
            // separate expressions
                new OperatorGroup( OperatorAssociativity.LeftToRight,
                    new BinaryOperator( COMMA )
                    ),
            // assignment operators
                new OperatorGroup( OperatorAssociativity.RightToLeft,
                    new BinaryOperator( EQ ),
                    new BinaryOperator( PLUSEQ ),
                    new BinaryOperator( MINUSEQ ),
                    new BinaryOperator( TIMESEQ ),
                    new BinaryOperator( DIVEQ ),
                    new BinaryOperator( MODEQ ),
                    new BinaryOperator( ANDEQ ),
                    new BinaryOperator( XOREQ ),
                    new BinaryOperator( OREQ ),
                    new BinaryOperator( LSHIFTEQ ),
                    new BinaryOperator( RSHIFTEQ )
                    ),
            // ternary operator
                new OperatorGroup( OperatorAssociativity.RightToLeft,
                    new TernaryOperator( QUES, COLON )
                    ),
            // boolean or
                new OperatorGroup( OperatorAssociativity.LeftToRight,
                    new BinaryOperator( OR )
                    ),
            // boolean and
                new OperatorGroup( OperatorAssociativity.LeftToRight,
                    new BinaryOperator( AND )
                    ),
            // bitwise or
                new OperatorGroup( OperatorAssociativity.LeftToRight,
                    new BinaryOperator( BITOR )
                    ),
            // bitwise xor
                new OperatorGroup( OperatorAssociativity.LeftToRight,
                    new BinaryOperator( BITXOR )
                    ),
            // bitwise and
                new OperatorGroup( OperatorAssociativity.LeftToRight,
                    new BinaryOperator( BITAND )
                    ),
            // comparison
                new OperatorGroup( OperatorAssociativity.LeftToRight,
                    new BinaryOperator( EQEQ ),
                    new BinaryOperator( NEQ )
                    ),
            // relational
                new OperatorGroup( OperatorAssociativity.LeftToRight,
                    new BinaryOperator( LT ),
                    new BinaryOperator( LE ),
                    new BinaryOperator( GT ),
                    new BinaryOperator( GE )
                    ),
            // shift
                new OperatorGroup( OperatorAssociativity.LeftToRight,
                    new BinaryOperator( LSHIFT ),
                    new BinaryOperator( RSHIFT )
                    ),
            // addition
                new OperatorGroup( OperatorAssociativity.LeftToRight,
                    new BinaryOperator( PLUS ),
                    new BinaryOperator( MINUS )
                    ),
            // multiply
                new OperatorGroup( OperatorAssociativity.LeftToRight,
                    new BinaryOperator( MUL ),
                    new BinaryOperator( DIV ),
                    new BinaryOperator( MOD )
                    ),
            // prefix right to left
                new OperatorGroup( OperatorAssociativity.RightToLeft,
                    new UnaryOperator( INC, UnaryOperatorType.Prefix, AST_PREINCREMENT ),
                    new UnaryOperator( DEC, UnaryOperatorType.Prefix, AST_PREDECREMENT ),
                    new UnaryOperator( PLUS, UnaryOperatorType.Prefix ),
                    new UnaryOperator( MINUS, UnaryOperatorType.Prefix ),
                    new UnaryOperator( NOT, UnaryOperatorType.Prefix ),
                    new UnaryOperator( BITNOT, UnaryOperatorType.Prefix ),
                    //new BinaryGroupOperator( LPAREN, RPAREN, UnaryOperatorType.Prefix, AST_CAST ),
                    new UnaryOperator( MUL, UnaryOperatorType.Prefix, AST_DEREFERENCE ),
                    new UnaryOperator( BITAND, UnaryOperatorType.Prefix, AST_ADDRESSOF ),
                    new UnaryOperator( SIZEOF, UnaryOperatorType.Prefix )
                    ),
            // postfix left to right
                new OperatorGroup( OperatorAssociativity.LeftToRight,
                    //new BinaryGroupOperator( LPAREN, RPAREN, UnaryOperatorType.Postfix, AST_CALL ),
                    //new BinaryGroupOperator( LBRACK, RBRACK, UnaryOperatorType.Postfix, AST_SUBSCRIPT ),
                    new BinaryOperator( DOT ),
                    new BinaryOperator( ARROW ),
                    new UnaryOperator( INC, UnaryOperatorType.Postfix, AST_POSTINCREMENT ),
                    new UnaryOperator( DEC, UnaryOperatorType.Postfix, AST_POSTDECREMENT )
                    )
                //, new OperatorGroup( OperatorAssociativity.LeftToRight,
                //    new UnaryGroupOperator( LPAREN, RPAREN )
                //    )
                );

        ITree CreatePrecedenceTree( List<BaseTree> expressions )
        {
            return Precedence.BuildExpressionTree( TreeAdaptor, expressions );
        }
    }
}
