package com.foo.bar.Test;

import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

@Aspect
public class MyAspect {

	@Before("call(void *..Addable.addNewData())")
	public void beforeAddNewData() {
		System.out.println("MyAspect: before adding new data");
	}

	@AfterReturning(pointcut = "call(String *..Addable.addNewString(String)) && args(add)", returning = "rst")
	public void afterAddNewDataReturning(String add, String rst) {
		System.out.println("MyAspect: add " + add + " and got " + rst);
	}

}
