package com.foo.bar.Test;


import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.foo.bar.Test.Addable;
import com.foo.bar.Test.AjdtWeaving;

import static org.easymock.EasyMock.*;
import static org.junit.Assert.*;

public class AjdtWeavingTest {
	
	Addable obj;

	@Before
	public void setUp() throws Exception {
		obj = createMock("obj", Addable.class);
		obj.addNewData();
		expect(obj.addNewString("ABC")).andReturn("ABC");
		replay(obj);
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void testAddNewData() {
		obj.addNewData();
		assertEquals("ABC", obj.addNewString("ABC"));
	}
	
	@Test
	public void testAjdtWeaving() {
		AjdtWeaving weavingObj = new AjdtWeaving();
		weavingObj.addNewData();
		weavingObj.addNewString("CCD");
	}
}
