package org.foo;

import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class CflowAspect {

	@Pointcut("execution(boolean *..CflowExample.validateParameter(..))")
	public void validate() {
	}

	@AfterReturning(pointcut = "call(boolean *..Properties.containsKey(Object)) && args(key) && cflow(validate())", returning = "existed")
	public void afterCheckExistence(String key, boolean existed) {
		System.out.println(key + " " + (existed ? "exists" : "doesn't exists"));
	}

}
