#! /bin/ksh
#
# Set MYSHELL to the ksh to be tested....
MYSHELL=$HOME/KSH93t/ksh.2010-03-09.sol10.i386
MYSHELL=/bin/ksh93

report=F
typeset -i error_cnt
error_cnt=0

report_test_result () {

  if [ "$report" = "PF" -o \( "$report" = "F" -a "$RESULT" = "FAIL" \) ]
  then
     print -f "%10d       %s\n" $SIZE  $RESULT
  fi
}

do_test () {
  rm -f config.status

  SIZE=`wc -c $1 | awk '{print $1;}'`

  print -n "\r    $SIZE\r"
  ${MYSHELL} ./$1 > /dev/null

  RESULT="passed"
  grep "^_ACAWK$" config.status > /dev/null || RESULT="FAIL"
  report_test_result
  [[ "$RESULT" = "FAIL" ]] && \
    {	mv config.status config.status.$SIZE 
	cp cf.sh cf.sh.$SIZE 
	error_cnt=$error_cnt+1 
    }
}

cp cf.sh.ORIG cf.sh
SIZE=`wc -c cf.sh | awk '{print $1;}'`

echo " "
echo "Starting size for cf.sh is:   $SIZE"
echo " "

do_test cf.sh

while (true) do
  for ((i = 0; i < 256; i++))
  do
    case $i in 
      0)	# print "$i: insterting newline"
	ed -s cf.sh <<-_EDEOF
	2a
	
	.
	w
	q
	_EDEOF
  	;;
      1)  # print "$i: converting to \" <newline>\""
  	ed -s cf.sh <<-_EDEOF
	3c
	 
	.
	w
	q
	_EDEOF
  	;;
      *)	# print "$i: adding a leading space"
  	ed -s cf.sh <<-_EDEOF
	3s/^./ &/
	w
	q
	_EDEOF
  	;;
    esac

    do_test cf.sh

    [[ $error_cnt -ge 9 ]] && exit 1
  done
done
print ""
