#!/usr/bin/perl


## calltest.perl - program to make test calls repeatedly on specified channel
##
##
## copyright (c) 2003 Emerging Voice Technology, Inc.
##
## calling sequence:  calltest.perl -c <channel> -d <destination> -r <runtime>
##
## <channel> is a valid asterisk channel number (skipping D channel!)
## <destination> is the destination number
## <runtime> is maximum runtime in MINUTES
##
## Calls will be made continuously, with random spacing between calls of 
## 4.5 to 7 seconds
## 
## Version 29Aug03 - Dynamically creates outgoing call records, also tests for
## 			existing call rec's.

$| = 1;
#$spooldir = "/etc/asterisk/scott/";
$spooldir = "/var/spool/asterisk/outgoing/";

use Getopt::Std;

getopts("c:d:r:");
print "Test channel $opt_c dest $opt_d ";
if($opt_r) {
	print "for $opt_r minutes\n";
}
else {
	print "indefinitely\n"
}

my $counter = 0;

# Remember start time (seconds since 1970!)
my $starttime = time;

while(1) {
	# first make sure the spool file doesn't already exist:
	$newfilename = $spooldir . $opt_c . ".call";
	if(sysopen(FHAND, $newfilename, O_RDONLY)) {
		# if already exists, wait 2 seconds and try again:
		printf STDERR "File $opt_c already exists - waiting 2 seconds\n";
		sleep 2;
		if(sysopen(FHAND, $newfilename, O_RDONLY)) {
			print STDERR "$opt_c still exists - exit!\n";
			exit(0);
		}
	}
	# close it  if we found it open (not likely needed)
	close FHAND;

	# Now form the output buffer:
	my $buffer1 = sprintf "Channel: Zap/%d/%s\n\n", $opt_c, $opt_d;
	$buffer1 = $buffer1 . "MaxRetries: 0\nRetryTime: 30\nWaitTime:15\n";
	$buffer1 = $buffer1 . "Context: outgoing\nExtension: s\nPriority: 1\n";
	$buffer1 = $buffer1 . "Callerid: 6503290730\n";

	# And write it!
	if(!(open FHAND2, ">", $newfilename)) {
		print STDERR "Error could not open for writing: $newfilename\n";
		exit(0);
	}
	printf FHAND2 "%s", $buffer1;
	close FHAND2;

	$counter = $counter + 1;

	# Now wait between 5 and 8 seconds

	$waitfloat = rand(2.5) + 4.5;
	# print "Wait $waitfloat seconds\n";
	select(undef, undef, undef, $waitfloat);

	# Check if we've run long enough
	if(($opt_r) && (((time-$starttime)/60) > $opt_r)) {
		print "Chan: $opt_c run complete - calls processed = $counter\n";
		exit;
	}

} # END OF WHILE LOOP
		

exit;



