#!/bin/sh
# run this to bootstrap the project

pname=PRJ
srcdir=`dirname $0`
test -z "$srcdir" && srcdir=.

DIE=0

(autoconf --version) < /dev/null > /dev/null 2>&1 || {
	echo
	echo "You must have autoconf installed to compile $pname."
	echo "Download the appropriate package for your distribution,"
	echo "or get the source tarball at ftp://ftp.gnu.org/pub/gnu/"
	DIE=1
}

(automake --version) < /dev/null > /dev/null 2>&1 || {
	echo
	echo "You must have automake installed to compile $pname."
	echo "Download the appropriate package for your distribution,"
	echo "or get the source tarball at ftp://ftp.gnu.org/pub/gnu/"
	DIE=1
}

if test "$DIE" -eq 1; then
	exit 1
fi

THEDIR="`pwd`"
cd $srcdir
aclocal $ACLOCAL_FLAGS
autoheader
autoconf
automake --foreign --add-missing
cd "$THEDIR"

echo "To configure $pname run 'configure' with the appropriate options."
echo 
