
#include <octave/config.h>

#include <iostream>
#include <sstream>
using namespace std;
#include <string>

#include <octave/defun-dld.h>
#include <octave/error.h>
#include <octave/oct-obj.h>
#include <octave/pager.h>
#include <octave/symtab.h>
#include <octave/variables.h>

DEFUN_DLD (foo, args, ,
  "return vector length\n")
{
  octave_value_list retval;
  
  /*----------- get input parameters ----------------*/
  int nargin = args.length ();
  
  if (nargin < 1)
    {
      error("Usage: length = foo(in)");
      return retval;
    }

  ColumnVector in(args(0).vector_value());
  
  retval(0)=(double) in.length();
  
  return retval;
}





