/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.tools.xdoclet;

import java.io.File;
import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;

public class BlockInfoSubTask
extends TemplateSubTask {
    public static final String SUBTASK_NAME = "blockinfo";
    protected static String mClassPattern;
    private String mTemplatePath = null;
    protected static String DEFAULT_TEMPLATE_FILE;
    private static String GENERATED_FILE_NAME;

    public BlockInfoSubTask() {
        this.setTemplateFile(new File(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(GENERATED_FILE_NAME);
        this.setHavingClassTag("phoenix:service");
        TemplateSubTask.ExtentTypes extentTypes = new TemplateSubTask.ExtentTypes();
        extentTypes.setValue("hierarchy");
        this.setExtent(extentTypes);
        this.setOfType("org.apache.avalon.phoenix.Block");
    }

    public void setTemplatePath(String string) {
        this.mTemplatePath = string;
        this.setTemplateFile(new File(string));
    }

    public static String getClassPattern() {
        return mClassPattern;
    }

    public String getSubTaskName() {
        return SUBTASK_NAME;
    }

    public void setPattern(String string) {
        mClassPattern = string;
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (this.mTemplatePath == null) {
            throw new XDocletException("'templatePath' attribute is missing .");
        }
        if (this.getTemplateFile() == null || !this.getTemplateFile().exists() || this.getTemplateFile().isDirectory()) {
            throw new XDocletException("'template' file is missing parameter missing .");
        }
        if (BlockInfoSubTask.getClassPattern() == null || BlockInfoSubTask.getClassPattern().trim().equals("")) {
            throw new XDocletException("'pattern' parameter missing or empty.");
        }
        if (BlockInfoSubTask.getClassPattern().indexOf("{0}") == -1) {
            throw new XDocletException("'pattern' parameter does not have a '{0}' in it. '{0}' is replaced by EJB name of the class under processing.");
        }
    }

    static {
        DEFAULT_TEMPLATE_FILE = "/src/manifest/blockinfo.j";
        GENERATED_FILE_NAME = "{0}.xinfo";
    }
}

