
package org.k2d2.framework.serverframework.pool;

/**
 * This class implements the container (wrapper) to manage the application
 * resources. The PoolManager uses this as its pooled object. This class
 * implements the PooledResource interface which applications can use
 * to access the actual resource.
 *
 * @author Karthik Rangaraju
 * @see PoolManager
 */
public class PooledResourceContainer implements PooledResource
{
    private PoolManager mManager;
    private Object mResource;
    
    // TODO: Move this code to org.k2d2.framework.serverframework.pool.container
    // and exclude from javadoc list
    /**
     * Constructor has been defined with default access permissions
     * to limit access to this package. This constructor is called
     * by PoolManager
     */
    PooledResourceContainer(PoolManager pManager)
    {
        mManager = pManager;
    }
    
    /**
     * Method used by PoolManager to set the container's managed
     * resource
     */
    void set(Object pResource)
    {
        mResource = pResource;
    }
    
    /**
     * Method of the PooledResource interface. Returns reference to
     * the managed resource
     * @return Object - reference to the managed resource as an Object.
     * The calling application should cast it to the appropriate type
     */
    public Object get()
    {
        return mResource;
    }
    
    /**
     * Method of the PooledResource inteface. This method releases the
     * managed resource for use by other threads or callers. Once release()
     * has been called, the application should not use its reference to
     * either the PooledResource object it has or the resource obtained
     * from the get() method call.
     * @see #get()
     */
    public void release()
    {
        mManager.reclaim(this);
    }
}
