
package org.k2d2.framework.threadpackage.util;

/**
 * This class provides a simple thread safe counter (max value MAXINT)
 * @author Karthik Rangaraju
 */
public class SynchronousCounter
{
	private int mCounter = 0;
	
	/**
	 * This method increases the counter value by one
	 */
	public synchronized void up()
	{
		mCounter++;
	}
	
	/**
	 * This method decreases the counter value by one
	 */
	public synchronized void down()
	{
		mCounter--;
	}
	
	/**
	 * This method increases the counter value by a specified number
	 * @param pCount the amount by which to increment the counter
	 */
	public synchronized void up(int pCount)
	{
		mCounter += pCount;
	}
	
	/**
	 * This method decreases the counter value by a specified number
	 * @param pCount the amount by which to decrement the counter
	 */
	public synchronized void down(int pCount)
	{
		mCounter -= pCount;
	}
	
	/**
	 * This method returns the value of the counter. I figured it may be
	 * a useful method to have around(?)
	 * @return an integer representing the current value of the counter
	 */
	public synchronized int getValue()
	{
		return mCounter;
	}
}
