package org.apache.avalon.excalibur.cache;

import java.util.Iterator;

/**
 * Store cached objects.
 *
 * @author <a href="mailto:colus@isoft.co.kr">Eung-ju Park</a>
 */
public interface CacheStore
{
    /**
     * Return capacity of store.
     *
     * @return capacity of store 
     */
    int capacity();

    /**
     * Return size of store.
     *
     * @return the number of key-value mappings in this store.
     */
    int size();

    boolean isFull();

    Object put( Object key, Object value );

    boolean containsKey( Object key );

    Object get( Object key );

    Object remove( Object key );

    /**
     * Return the list of all key.
     */
    Iterator list();
}
