package com.thinkdynamics.phoenix.components.embeddor;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.phoenix.components.embeddor.DefaultEmbeddor;
import org.apache.avalon.phoenix.interfaces.Deployer;

/**
 * @author ifedorenko
 */
public class URLEmbeddor extends DefaultEmbeddor {

    private final List m_applications = new ArrayList();

    public void configure( final Configuration configuration )
            throws ConfigurationException {
        super.configure(configuration);
        final Configuration[] applications = configuration.getChildren("application");
        for (int i = 0; i < applications.length; i++) {
            m_applications.add(applications[i].getAttribute("location"));
        }
    }

    protected void deployDefaultApplications() throws Exception {
        getLogger().info(m_applications.toString());
        Deployer deployer = (Deployer) getEmbeddorComponent(Deployer.ROLE);

//        String application =
//            getParameters().getParameter( "application-location", null );
//        if( null != application )
//        {
//            URL url = new URL( application );
//            deployer.deploy(new File(url.getFile()).getName(), url);
//        }

        super.deployDefaultApplications();
        for (int i = 0; i < m_applications.size(); i++) {
            URL url = new URL((String) m_applications.get(i));
            deployer.deploy(new File(url.getFile()).getName(), url);
        }
    }
}
