package com.thinkdynamics.phoenix.components.installer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.interfaces.FileDigest;
import org.apache.avalon.phoenix.interfaces.Installation;
import org.apache.avalon.phoenix.interfaces.InstallationException;
import org.apache.avalon.phoenix.interfaces.Installer;

import com.thinkdynamics.eclipse.EclipseDeploymentException;
import com.thinkdynamics.eclipse.EclipseProject;

/**
 * @author ifedorenko
 */
public class EclipseInstaller extends AbstractLogEnabled 
        implements Installer, Configurable {

    //The names on the native filesystem
    private static final String FS_CONFIG_XML = "SAR-INF" + File.separator + "config.xml";

    private static final String FS_ASSEMBLY_XML = "SAR-INF" + File.separator + "assembly.xml";

    private static final String FS_ENV_XML = "SAR-INF" + File.separator + "environment.xml";

    private URL workspace;

    /**
     * @see org.apache.avalon.phoenix.interfaces.Installer#install(String, URL)
     */
    public Installation install(String name, URL url)
            throws InstallationException {
        try {
            EclipseProject project = new EclipseProject(workspace, url);

            // directory in .sar format (=> bin of a project)
            final File source = new File(project.getOutputFolder().getFile());

            // directory application is installed into (=> same as source)
            final File directory = source;

            // directory in which temporary data for this application
            // is stored, used to creare classloader (=> same as source???)
            final File workDirectory = source;

            // should I look for resources in project?
            final String config = new File(directory, FS_CONFIG_XML).toURL().toExternalForm();
            final String assembly = new File(directory, FS_ASSEMBLY_XML).toURL().toExternalForm();
            final String environment = new File(directory, FS_ENV_XML).toURL().toExternalForm();

            final String[] classPath = getProjectClasspath(project);
            final FileDigest[] digests = null;
            final long timestamp = System.currentTimeMillis();
            return new Installation(source,
                    directory,
                    workDirectory,
                    config,
                    assembly,
                    environment,
                    classPath,
                    digests,
                    timestamp);
        } catch (EclipseDeploymentException e) {
            throw new InstallationException(null, e);
        } catch (MalformedURLException e) {
            // never happens
            throw new InstallationException(null, e);
        }
    }

    /**
     * @see org.apache.avalon.phoenix.interfaces.Installer#setBaseDirectory(File)
     */
    public void setBaseDirectory(File baseDirectory) {
    }

    /**
     * @see org.apache.avalon.phoenix.interfaces.Installer#setBaseWorkDirectory(File)
     */
    public void setBaseWorkDirectory(File baseWorkDirectory) {
    }

    /**
     * @see org.apache.avalon.phoenix.interfaces.Installer#uninstall(Installation)
     */
    public void uninstall(Installation installation)
        throws InstallationException {
    }

    /**
     * @see org.apache.avalon.framework.configuration.Configurable#configure(Configuration)
     */
    public void configure(Configuration configuration)
            throws ConfigurationException {
        try {
            workspace = new URL(configuration.getChild( "eclipse-workspace" ).getValue());
        } catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid eclipse workspace url", e);
        }
    }

    //
    //
    //

    private String[] getProjectClasspath(EclipseProject project) {
        Set classpath = new HashSet();
        classpath.add(project.getOutputFolder().toExternalForm());
        Iterator exps = project.getExportedLibUrls();
        while (exps.hasNext()) {
            URL entry = (URL) exps.next();
            if (EclipseProject.isProjectURL(entry)) {
                try {
                    EclipseProject required = new EclipseProject(workspace, entry);
                    classpath.addAll(Arrays.asList(getProjectClasspath(required)));
                } catch (EclipseDeploymentException e) {
                    getLogger().error("Cannot load required project", e);
                }
            } else {
                classpath.add(entry.toExternalForm());
            }
        }
        return (String[]) classpath.toArray(new String[classpath.size()]);
    }
}
