.PHONY: program program_fuses verify erase
ifndef AVR_PROGRAM
$(error AVR_PROGRAM must be set to the desired name of the executable)
endif

ifndef AVRDUDE_PART
$(error AVRDUDE_PART must be set to the part being programmed)
endif

AVRDUDE       = avrdude
AVRDUDE_PROG  ?= avrispv2
AVRDUDE_PORT  ?= /dev/tty.usbserial-FTC9OBMP
AVRDUDE_FLAGS ?= -D
AVR_SPP = ${AVR_PROGDIR}/${AVR_PROGRAM}

program: ${AVR_SPP}.hex program_fuses 
	if ! ${AVRDUDE} -c ${AVRDUDE_PROG} -p ${AVRDUDE_PART} -P ${AVRDUDE_PORT} ${AVRDUDE_FLAGS} -U flash:v:${AVR_SPP}.hex && \
		for section in eeprom lock; do \
			if [[ -s ${AVR_SPP}_$${section}.hex ]]; then \
				${AVRDUDE} -c ${AVRDUDE_PROG} -p ${AVRDUDE_PART} -P ${AVRDUDE_PORT} ${AVRDUDE_FLAGS} -U $${section}:v:${AVR_SPP}_$${section}.hex; \
			fi; \
		done; then \
		${AVRDUDE} -c ${AVRDUDE_PROG} -p ${AVRDUDE_PART} -P ${AVRDUDE_PORT} ${AVRDUDE_FLAGS} -e; \
		${AVRDUDE} -c ${AVRDUDE_PROG} -p ${AVRDUDE_PART} -P ${AVRDUDE_PORT} ${AVRDUDE_FLAGS} -U flash:w:${AVR_SPP}.hex; \
		for section in eeprom lock; do \
			if [[ -s ${AVR_SPP}_$${section}.hex ]]; then \
				${AVRDUDE} -c ${AVRDUDE_PROG} -p ${AVRDUDE_PART} -P ${AVRDUDE_PORT} ${AVRDUDE_FLAGS} -U $${section}:w:${AVR_SPP}_$${section}.hex; \
			fi; \
		done; \
	fi

program_fuses: ${AVR_SPP}.hex
	for section in lfuse hfuse efuse fuse; do \
		if [[ -s ${AVR_SPP}_$${section}.hex ]]; then \
			${AVRDUDE} -c ${AVRDUDE_PROG} -p ${AVRDUDE_PART} -P ${AVRDUDE_PORT} ${AVRDUDE_FLAGS} -U $${section}:v:${AVR_SPP}_$${section}.hex || \
				${AVRDUDE} -c ${AVRDUDE_PROG} -p ${AVRDUDE_PART} -P ${AVRDUDE_PORT} ${AVRDUDE_FLAGS} -U $${section}:w:${AVR_SPP}_$${section}.hex; \
		fi; \
	done

verify: ${AVR_SPP}.hex ${AVR_SPP}_*.hex
	${AVRDUDE} -c ${AVRDUDE_PROG} -p ${AVRDUDE_PART} -P ${AVRDUDE_PORT} ${AVRDUDE_FLAGS} -U flash:v:${AVR_SPP}.hex
	for section in $(patsubst ${AVR_PROGRAM}_%.hex,%,$(filter ${AVR_PROGRAM}_%.hex,$(notdir $^))); do \
		if [[ -s ${AVR_SPP}_$${section}.hex ]]; then \
			${AVRDUDE} -c ${AVRDUDE_PROG} -p ${AVRDUDE_PART} -P ${AVRDUDE_PORT} ${AVRDUDE_FLAGS} -U $${section}:v:${AVR_SPP}_$${section}.hex; \
		fi; \
	done

erase:
	${AVRDUDE} -c ${AVRDUDE_PROG} -p ${AVRDUDE_PART} -P ${AVRDUDE_PORT} ${AVRDUDE_FLAGS} -e
