#include <inttypes.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>
#include <avr/fuses.h>
#include "config.h"
#include "servo_input.h"
#include "serial.h"
#include "debug.h"
#include "example.h"

/* Set the clock speed to 1MHz */
LFUSE = SUT0 & CKSEL3 & CKSEL2;

/* Pins
 *
 * GREEN	PD5
 * RED		PD6
 */

/* Globals to keep track of current state */
direction_t	motor_direction = FORWARD;
uint8_t		motor_speed = 0;

int main()
{
	FILE serial;

	/* Sleep should make us go into IDLE mode */
	set_sleep_mode(0);

	/* Open up the serial port for debugging */
	serial_open(0, SERIAL_BAUD_19200, 8, SERIAL_PARITY_NONE, 1, &serial);
	stdout = stderr = stdin = &serial;

	DEBUG_PRINTF("%s", "Starting up...\n");

	/* Initialize the servo input code */
	servo_init();

	/* Turn on interrupts */
	sei();

	/* Go into a loop that just sleeps, everything important is
	 * done in the ISR
	 */
	while (1) {
		sleep_mode();
	}

	return 0;
}
