#ifndef SERIAL_H
#define SERIAL_H

#include <stdio.h>

typedef enum {
	SERIAL_PARITY_NONE,
	SERIAL_PARITY_EVEN,
	SERIAL_PARITY_ODD
} serial_parity_t;

typedef enum {
	SERIAL_BAUD_2400,
	SERIAL_BAUD_4800,
	SERIAL_BAUD_9600,
	SERIAL_BAUD_14400,
	SERIAL_BAUD_19200,
	SERIAL_BAUD_28800,
	SERIAL_BAUD_38400,
	SERIAL_BAUD_57600,
	SERIAL_BAUD_76800,
	SERIAL_BAUD_115200,
	SERIAL_BAUD_230400,
	SERIAL_BAUD_250000,
	SERIAL_BAUD_COUNT
} serial_baud_t;

/* Param:  baud_rate - The baud rate to use for this port
 * Param:  data_bits - The number of bits of data to be sent in each word
 * Param:  parity    - The type of parity to be used
 * Param:  stop_bits - The number of bits in each word to indicate the end of the word
 * Return: An error code as defined in error.h
 */
int serial_open(int port, serial_baud_t baud_rate, uint8_t data_bits, serial_parity_t parity, uint8_t stop_bits, FILE * fd);

#endif /* SERIAL_H */
