/***********************************************************
 *
 *	fuses.h - Fuse and lock bit definitions
 *
 *  Copyright 2006-2007 Steven Michalske
 *	Author - Steven Michalske
 *	Modifications - Rick Altherr
 *
 *  The fuse and lock bytes exist outside the normal program
 *  and eeprom space for an AVR device.  This poses a problem
 *  for the traditional programming model.  To accommodate a
 *  more programmer friendly approach, this header files
 *  provides a mechanism to specify these settings from
 *  within the source code for the device's program.  Each
 *  fuse and/or lock byte has a designated macro that
 *  creates a variable that will be placed in a special
 *  section of the resulting ELF binary.  Then, with the use
 *  of objcopy, those sections can be extracted and programmed
 *  as part of a Makefile.  Macros are also provided for the
 *  bit definitions for each fuse and lock byte so the
 *  desired value for the byte can easily be specified.
 *  An example would be:
 *     HFUSE = JTAGEN & SPIEN & BOOTSZ1 & BOOTSZ0
 ************************************************************/

#ifndef __FUSES_H__
#define __FUSES_H__

#include <avr/sfr_defs.h>

#if defined(__AVR_ATmega8__)
#include <avr/fusesm8.h>
#elif defined(__AVR_ATmega16__)
#include <avr/fusesm16.h>
#endif

#endif
