#include "axis2_stub_MyService.h"

#include <stdio.h>
#include <axiom.h>
#include <axis2_util.h>
#include <axiom_soap.h>
#include <axis2_client.h>


int main(int argc, char **argv)
{
    /** the core variables */
    axutil_env_t *env = NULL;
    axis2_char_t *client_home = NULL;
    axis2_char_t *endpoint_uri = NULL;
    axis2_stub_t *stub = NULL;

    axis2_status_t error_code;

    /** variables for axis2_stub_MyService*/
    adb_myOperationResponse_t* op_response;
    adb_myOperation_t* op;

    endpoint_uri = "http://localhost:9090/axis2/services/MyService";
    myservices_error_init();
    env = axutil_env_create_all("alltest.log", AXIS2_LOG_LEVEL_TRACE);
    client_home = AXIS2_GETENV("AXIS2C_HOME");

    stub = axis2_stub_MyService_create(env, client_home, endpoint_uri);

    /***************************************************************
     * Serialization test
     ****************************************************************/

    op = adb_myOperation_create(env);
    adb_myOperation_set_myInput(op, env, "Test1");

    op_response = axis2_stub_MyService_myOperation(stub, env, op);
    /** here op response is NULL anyway */
    if(op_response == NULL)
    {

        printf("ERROR: %d, %s\n", env->error->error_number, myservices_error_get_message(env->error));
        
    }

    adb_myOperation_set_myInput(op, env, "Test2");
    op_response = axis2_stub_MyService_myOperation(stub, env, op);
    
    if(op_response == NULL)
    {

        printf("ERROR: %d, %s\n", env->error->error_number, myservices_error_get_message(env->error));
        
    }

    return 0;
}
