#include "axis2_stub_Adder.h"

#include <stdio.h>
#include <axiom.h>
#include <axis2_util.h>
#include <axiom_soap.h>
#include <axis2_client.h>

#define LOOP_SIZE 100

int main(int argc, char **argv)
{
    /** the core variables */
    axutil_env_t *env = NULL;
    axis2_char_t *client_home = NULL;
    axis2_char_t *endpoint_uri = NULL;
    axis2_stub_t *stub = NULL;

    /** variables for simple add */
    adb_simpleAdd_t *simple_add;
    adb_simpleAddResponse_t *simple_add_res;

    /** variable for matrix add */
    int i,j;
    adb_Matrix_t *matrix0;
    adb_Matrix_t *matrix1;
    adb_Matrix_t *result_matrix;
    adb_MatrixRow_t *row;
    adb_matrixAdd_t *matrix_add;
    adb_matrixAddResponse_t *matrix_add_res;
    adb_matrixAddType_t *matrix_add_type;

    /** for the deserializing */
    axiom_node_t *payload;

    endpoint_uri = "http://localhost:9090/axis2/services/Adder";
    env = axutil_env_create_all("alltest.log", AXIS2_LOG_LEVEL_TRACE);
    client_home = AXIS2_GETENV("AXIS2C_HOME");

    stub = axis2_stub_Adder_create(env, client_home, endpoint_uri);

    /***************************************************************
     * Serialization test
     ****************************************************************/
    /** test for simple add */
    simple_add = adb_simpleAdd_create(env);
    adb_simpleAdd_set_param0(simple_add, env, 3);
    adb_simpleAdd_set_param1(simple_add, env, 4);

    simple_add_res = axis2_stub_Adder_simpleAdd(stub, env, simple_add);
    /** just ignore the response */ 


    /** test for matrix add */
    matrix_add = adb_matrixAdd_create(env);
    matrix_add_type = adb_matrixAddType_create(env);

    matrix0 = adb_Matrix_create(env);
    matrix1 = adb_Matrix_create(env);

    /** populate the 1st matrix */
    for(i = 0; i < 3; i ++)
    {
        row = adb_MatrixRow_create(env);
        for(j = 0; j < 3; j ++)
        {
            adb_MatrixRow_add_columns(row, env, i*3 + j);
        }
        adb_Matrix_add_rows(matrix0, env, row);
    }

    /** populate the 2nd matrix */
    for(i = 0; i < 3; i ++)
    {
        row = adb_MatrixRow_create(env);
        for(j = 0; j < 3; j ++)
        {
            adb_MatrixRow_add_columns(row, env, i*3 + j + 9);
        }
        adb_Matrix_add_rows(matrix1, env, row);
    }

    adb_matrixAddType_set_param0(matrix_add_type, env, matrix0);
    adb_matrixAddType_set_param1(matrix_add_type, env, matrix1);


    adb_matrixAdd_set_matrixAdd(matrix_add, env, matrix_add_type);


    for(i = 0; i < LOOP_SIZE; i ++)
    {
        matrix_add_res = axis2_stub_Adder_matrixAdd(stub, env, matrix_add);
    }

    /***************************************************************
     * Deserialization test
     ****************************************************************/
    /** just for the matrix add */

    if(matrix_add_res)
    {
	
	    result_matrix = adb_matrixAddResponse_get_return(matrix_add_res, env);

        if(result_matrix)
        {    
		    printf("Deserialized result matrix:\n");
		    for(i = 0; i < adb_Matrix_sizeof_rows(result_matrix, env); i ++)
		    {
		        row = adb_Matrix_get_rows_at(result_matrix, env, i);
		        for(j = 0; j < adb_MatrixRow_sizeof_columns(row, env); j ++)
		        {
		            printf("%d ", adb_MatrixRow_get_columns_at(row, env, j));
		        }
		        printf("\n");
		    }
        }
    }

    return 0;
}
