import java.io.IOException;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;

import javax.net.ssl.SSLSocketFactory;

import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

/** An adaptor class that allows a javax.net.SSLSocketFactory to be used as an 
 * org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory
 *  <br>$Id: SSLFactoryAdaptor.java 113 2007-08-23 11:28:48Z sjh $  
 *  <br>Copyright (c) British Telecommunications plc 2007
 *
 *  @author SJ Hindmarch
 *  @version $Rev: 113 $
 */
public class SSLFactoryAdaptor implements SecureProtocolSocketFactory{
    private final SSLSocketFactory factory;

    public SSLFactoryAdaptor(SSLSocketFactory factory){
	this.factory=factory;
    }

    public Socket createSocket(String host,int port)
	throws IOException,UnknownHostException{
	return factory.createSocket(host,port);
    }

    public Socket createSocket(String host,int port,InetAddress localAddress
			,int localPort)
	throws IOException,UnknownHostException{
	return factory.createSocket(host,port,localAddress,localPort);
    }

    public Socket createSocket(String host,int port,InetAddress localAddress
			,int localPort,HttpConnectionParams params)
	throws IOException,UnknownHostException{

        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }

        int timeout = params.getConnectionTimeout();
        if (timeout==0) {
            return factory.createSocket(host,port,localAddress,localPort);
        }else{
            Socket socket = factory.createSocket();
            SocketAddress localSocketAddress=new InetSocketAddress(
		localAddress,localPort);
            SocketAddress remoteSocketAddress=new InetSocketAddress(
		host,port);
            socket.bind(localSocketAddress);
            socket.connect(remoteSocketAddress,timeout);
            return socket;
        }
    }

    public Socket createSocket(Socket socket,String host,int port
			       ,boolean autoClose)
	throws IOException,UnknownHostException{
	return createSocket(socket,host,port,autoClose);
    }
}	
