import samples.quickstart.StockQuoteServiceStub;

import org.apache.commons.httpclient.protocol.Protocol;

/** Application to exercise stock quote client interface
 *  <br>$Id: StockQuoteClient.java 113 2007-08-23 11:28:48Z sjh $  
 *  <br>Copyright (c) British Telecommunications plc 2007
 *
 *  @author SJ Hindmarch
 *  @version $Rev: 113 $
 */
public class StockQuoteClient{
    /* Connect to an HTTP service */
    public static final String SERVICE_LOCATION_HTTP=
    "http://localhost:8080/axis2/services/StockQuoteService";
    /* Connect to an HTTPS service to show certificate signing error */
    public static final String SERVICE_LOCATION_HTTPS=
    "https://localhost:8443/axis2/services/StockQuoteService";
    /* Connect to an HTTPS service with bespoke socket factory to show 
    * "Transport Out Not Set" error */
    public static final String SERVICE_LOCATION_MYSSL=
    "myssl://localhost/axis2/services/StockQuoteService";

    /* Change this value to try the different tests */
    public static final String SERVICE_LOCATION=SERVICE_LOCATION_MYSSL;

    private final StockQuoteServiceStub stub;
    private final TrustingSSLSocketFactory sslSocketFactory;

    public static void main(String[] args){
	System.out.println("Test client started");
	String symbol="ABC";
	double price=100.01;
	if(args.length>0){
	    symbol=args[0];
	}
	if(args.length>1){
	    String priceS=args[1];
	    try{
		price=Double.parseDouble(priceS);
	    }catch(NumberFormatException e){
		System.out.println("Could not parse price parameter \""
				   +priceS+"\"");
	    }
	}
	System.out.println(
	    "Checking symbol "+symbol+" and setting price to "+price);

	try{
	    StockQuoteClient tester=new StockQuoteClient(SERVICE_LOCATION);
	    System.out.println("Checking price");
	    System.out.println("price="+tester.getPrice(symbol));
	    System.out.println("Setting price");
	    tester.setPrice(symbol,price);
	    System.out.println("Checking price again");
	    System.out.println("price="+tester.getPrice(symbol));
	}catch(Exception e){
	    System.out.println("Caught "+e);
	    e.printStackTrace(System.out);
	}
    }

    public StockQuoteClient(String location)
	throws Exception{
	stub=new StockQuoteServiceStub(location);
	sslSocketFactory=new TrustingSSLSocketFactory();
	Protocol.registerProtocol(
	    "mySSL",new Protocol("https",sslSocketFactory,8443));
    }

    public double getPrice(String symbol)
	throws Exception{
	StockQuoteServiceStub.GetPrice request=
	new StockQuoteServiceStub.GetPrice();

	request.setSymbol(symbol);

	StockQuoteServiceStub.GetPriceResponse response=stub.getPrice(request);

	return response.get_return();
    }

    public void setPrice(String symbol,double price)
	throws Exception{
	StockQuoteServiceStub.Update request=
	new StockQuoteServiceStub.Update();

	request.setSymbol(symbol);
	request.setPrice(price);

	stub.update(request);
    }

}
	    

