import java.io.IOException;

import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

/** A socket factory class to completely trust the server
 *  <br>$Id: TrustingSSLSocketFactory.java 112 2007-08-23 10:27:33Z sjh $  
 *
 *  @author SJ Hindmarch
 *  @version $Rev: 112 $
 */
public class TrustingSSLSocketFactory implements ProtocolSocketFactory{
    private final NullTrustManager tm=new NullTrustManager();
    private final X509TrustManager[] tms={tm};
    private final SSLContext ctx;
    private final SSLSocketFactory sf;
    private final SSLFactoryAdaptor sfa;

    public TrustingSSLSocketFactory()
	throws KeyManagementException,NoSuchAlgorithmException{
	ctx=SSLContext.getInstance("SSL");
	ctx.init(null,tms,null);
	sf=ctx.getSocketFactory();
	sfa=new SSLFactoryAdaptor(sf);
    }

    public Socket createSocket(String host,int port)
	throws IOException,UnknownHostException{
	return sfa.createSocket(host,port);
    }

    public Socket createSocket(String host,int port,InetAddress localAddress
			       ,int localPort)
	throws IOException,UnknownHostException{
	return sfa.createSocket(host,port,localAddress,localPort);
    }

    public Socket createSocket(String host,int port,InetAddress localAddress
			       ,int localPort,HttpConnectionParams params)
	throws IOException,UnknownHostException{
	return sfa.createSocket(host,port,localAddress,localPort,params);
    }

    public Socket createSocket(Socket socket,String host,int port
			       ,boolean autoClose)
	throws IOException,UnknownHostException{
	return sfa.createSocket(socket,host,port,autoClose);
    }

}
