package com.sample.service.mtom;

import java.io.File;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMText;
import org.apache.log4j.Logger;

/**
 * SpcltyPersAutoPolicyQuoteImpl
 */
public class MTOMSampleServiceImpl extends MTOMSampleServiceSkeleton {

	private static String fileFolder = "c:/temp/trailingDocs";

	private static Logger log = Logger.getLogger(MTOMSampleServiceImpl.class);

	public org.apache.axiom.om.OMElement getMTOMSampleService(
			org.apache.axiom.om.OMElement mTOMDocumentRequest) {
		mTOMDocumentRequest.build();
		mTOMDocumentRequest.detach();
		
		//Since we know that the first element is documentName
        OMElement documentName = mTOMDocumentRequest.getFirstElement();
        String fileName = documentName.getText();

		DataHandler dataHandler = new javax.activation.DataHandler(
				new FileDataSource(fileFolder + File.separator + fileName));
		OMFactory factory = OMAbstractFactory.getOMFactory();
		OMNamespace types = factory.createOMNamespace(
				"http://sample.service.com/mtom/types", "types");
		OMElement response = factory.createOMElement("MTOMDocumentResponse",
				types);
		factory.createOMElement("documentName", null, response).setText(
				fileName);
		OMElement binaryElement = factory.createOMElement("documentBinaryData",
				null, response);
		OMText binaryNode = factory.createOMText(dataHandler, true);
		binaryElement.addChild(binaryNode);

		return response;
	}
}
