--- lib/BackupPC/CGI/GeneralInfo.pm.orig	2013-10-08 15:16:50.000000000 +0400
+++ lib/BackupPC/CGI/GeneralInfo.pm	2013-10-08 14:47:28.000000000 +0400
@@ -43,6 +43,8 @@
     GetStatusInfo("info jobs hosts queueLen");
     my $Privileged = CheckPermission();
 
+    RRDGraph();
+
     my($jobStr, $statusStr);
     foreach my $host ( sort(keys(%Jobs)) ) {
         my $startTime = timeStamp2($Jobs{$host}{startTime});
@@ -127,8 +129,20 @@
     } elsif ( $Info{cpool4FileCnt} > 0 ) {
         $poolInfo = $cpoolInfo;
     }
-    my $generalInfo = eval("qq{$Lang->{BackupPC_Server_Status_General_Info}}")
-                                if ( $Privileged );
+
+    my $generalInfo = "";
+    if ( $Privileged ) {
+        $generalInfo  = eval("qq{$Lang->{BackupPC_Server_Status_General_Info}}");
+        $generalInfo .= '
+<ul>
+    <ul>
+        <p><img src="' . $MyURL . '?image=4">
+        <p><img src="' . $MyURL . '?image=52">
+    </ul>
+</ul>'
+          if ( -r "$LogDir/pool.rrd" && -x "$BinDir/rrdtool" );
+    }
+
     my $content = eval("qq{$Lang->{BackupPC_Server_Status}}");
     Header($Lang->{H_BackupPC_Server_Status}, $content);
     Trailer();
@@ -151,4 +165,107 @@
     return eval("qq{$Lang->{Pool_Stat}}");
 }
 
+#
+# Generate pool size RRDtool graph image
+#
+sub RRDGraph()
+{
+
+    if ( $In{image} ne "" ) {
+        $In{image} =~ /([0-9]+)/;
+        my $weeks = $1;
+        my $real  = $<;    ### SUID
+        $< = $>;           ### SUID
+
+        #
+        # Get each pool max value from RRD
+        #
+        my $poolSizeGraphv =
+            "$BinDir/rrdtool graphv -"
+          . " --start=end-4w --end=-300"
+          . ' DEF:p3kB="' . "$LogDir" . '/pool.rrd":p3kB:AVERAGE'
+          . ' DEF:c3kB="' . "$LogDir" . '/pool.rrd":c3kB:AVERAGE'
+          . ' DEF:p4kB="' . "$LogDir" . '/pool.rrd":p4kB:AVERAGE'
+          . ' DEF:c4kB="' . "$LogDir" . '/pool.rrd":c4kB:AVERAGE'
+          . ' PRINT:p3kB:MAX:%lf'
+          . ' PRINT:c3kB:MAX:%lf'
+          . ' PRINT:p4kB:MAX:%lf'
+          . ' PRINT:c4kB:MAX:%lf';
+        open( RRDGRAPHV, "-|", $poolSizeGraphv )
+          or die "cannot execute $poolSizeGraphv : $!";
+        my @poolMax;
+        while (<RRDGRAPHV>) {
+            /^print\[([0-3])\] = "([.0-9]+)"$/;
+            $poolMax[$1] = $2
+              unless ( $2 == 0 );
+        }
+        close RRDGRAPHV;
+
+        my $poolSizeGraph = "$BinDir/rrdtool graph -"
+          . " --start=end-${weeks}w --end=-300"
+          . ' --title="BackupPC Pool Size (' . ${weeks} . ' weeks)"'
+          . ' --vertical-label=""'
+          . ' --width=600 --height=100 --rigid --alt-autoscale-max'
+          . ' --base=1024 --logarithmic --units=si'
+          . ' --color BACK#FFFFFF --slope-mode --imgformat=PNG'
+          . ' --font TITLE:10: --font AXIS:8: --font LEGEND:8: --font UNIT:8:'
+          . ' --font-render-mode mono'
+          . ' DEF:p3kB="' . "$LogDir" . '/pool.rrd":p3kB:AVERAGE'
+          . ' DEF:c3kB="' . "$LogDir" . '/pool.rrd":c3kB:AVERAGE'
+          . ' DEF:p4kB="' . "$LogDir" . '/pool.rrd":p4kB:AVERAGE'
+          . ' DEF:c4kB="' . "$LogDir" . '/pool.rrd":c4kB:AVERAGE'
+          . ' DEF:tpkB="' . "$LogDir" . '/pool.rrd":tpkB:AVERAGE'
+          . ' CDEF:p3B=p3kB,1024,*'
+          . ' CDEF:c3B=c3kB,1024,*'
+          . ' CDEF:p4B=p4kB,1024,*'
+          . ' CDEF:c4B=c4kB,1024,*'
+          . ' CDEF:tpB=tpkB,1024,*';
+
+        #
+        # Draw stacked pool graphs (and legend entry) for non empty pools
+        #
+        $poolSizeGraph .=
+            ' AREA:p3B#FFADA7:"Pool  V3 in bytes               "'
+          . ' GPRINT:p3B:LAST:"Current\\:%8.2lf %s"'
+          . ' GPRINT:p3B:AVERAGE:"Average\\:%8.2lf %s"'
+          . ' GPRINT:p3B:MAX:"Maximum\\:%8.2lf %s\n"'
+          if $poolMax[0];
+
+        $poolSizeGraph .=
+            ' AREA:c3B#FFDBA7:"CPool V3 in bytes               ":STACK'
+          . ' GPRINT:c3B:LAST:"Current\\:%8.2lf %s"'
+          . ' GPRINT:c3B:AVERAGE:"Average\\:%8.2lf %s"'
+          . ' GPRINT:c3B:MAX:"Maximum\\:%8.2lf %s\n"'
+          if $poolMax[1];
+
+        $poolSizeGraph .=
+            ' AREA:p4B#97E7A5:"Pool  V4 in bytes               ":STACK'
+          . ' GPRINT:p4B:LAST:"Current\\:%8.2lf %s"'
+          . ' GPRINT:p4B:AVERAGE:"Average\\:%8.2lf %s"'
+          . ' GPRINT:p4B:MAX:"Maximum\\:%8.2lf %s\n"'
+          if $poolMax[2];
+
+        $poolSizeGraph .=
+            ' AREA:c4B#95B8DB:"CPool V4 in bytes               ":STACK'
+          . ' GPRINT:c4B:LAST:"Current\\:%8.2lf %s"'
+          . ' GPRINT:c4B:AVERAGE:"Average\\:%8.2lf %s"'
+          . ' GPRINT:c4B:MAX:"Maximum\\:%8.2lf %s\n"'
+          if $poolMax[3];
+        #
+        # Draw total line graph
+        #
+        $poolSizeGraph .=
+            ' LINE1:tpB#FF0000:"Prior to pooling and compression"'
+          . ' GPRINT:tpB:LAST:"Current\\:%8.2lf %s"'
+          . ' GPRINT:tpB:AVERAGE:"Average\\:%8.2lf %s"'
+          . ' GPRINT:tpB:MAX:"Maximum\\:%8.2lf %s\\n"';
+
+        print "Content-type: image/png\n\n";
+        print `$poolSizeGraph`;
+
+        $< = $real;    ### SUID
+        return;
+    }
+}
+
 1;
