# -*- coding: utf-8 -*-

# Provides a button to be used on a screen. Uses code from Simon H. Larsen's
# Buttons library.
#
# Author: Nick Apperley.

import pygame
from pygame.locals import *


class Button:
    def create_button(self, surface, color, x, y, length, height, width, text,
        text_color):
        surface = self.draw_button(surface, color, length, height, x, y, width)

        surface = self.write_text(surface, text, text_color, length, height,
            x, y)
        self.rect = pygame.Rect(x, y, length, height)
        return surface

    def write_text(self, surface, text, text_color, length, height, x, y):
        font_size = int(length / len(text))
        myFont = pygame.font.SysFont("Calibri", font_size)
        myText = myFont.render(text, 1, text_color)

        surface.blit(myText, ((x + length / 2) - myText.get_width() / 2,
            (y + height / 2) - myText.get_height() / 2))
        return surface

    def draw_button(self, surface, color, length, height, x, y, width):
        alpha = -1
        bs = None

        for i in range(1, 10):
            bs = pygame.Surface((length + (i * 2), height + (i * 2)))
            bs.fill(color)
            alpha = (255 / (i + 2))
            if alpha <= 0:
                alpha = 1
            bs.set_alpha(alpha)
            pygame.draw.rect(bs, color, (x - i, y - i, length + i, height + i),
                width)
            surface.blit(bs, (x - i, y - i))
        pygame.draw.rect(surface, color, (x, y, length, height), 0)
        pygame.draw.rect(surface, (190, 190, 190), (x, y, length, height), 1)
        return surface

    def pressed(self, mouse):
        result = True

        if mouse[0] > self.rect.topleft[0]:
            if mouse[1] > self.rect.topleft[1]:
                if mouse[0] < self.rect.bottomright[0]:
                    if mouse[1] < self.rect.bottomright[1]:
                        result = True
                    else:
                        result = False
                else:
                    result = False
            else:
                result = False
        else:
            result = False
        return result
