#include <ctype.h>
#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h> 
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>
#include <errno.h>

#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ioctl.h>

#include <X11/xpm.h>
#include <X11/Xlib.h>
#include <X11/extensions/shape.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>

#include "../wmgeneral/misc.h"
#include "../wmgeneral/wmgeneral.h"

#include "bbrun.xpm"


#define CHAR_WIDTH 5
#define CHAR_HEIGHT 7
#define SEC_IN_MIN 60
#define YES 1
#define NO 0
#define MAXHISTLEN 10
#define VERSION "1.0"

int wminet_mask_width = 16;
int wminet_mask_height = 16;
char wminet_mask_bits[16 * 16];

extern char **environ;

int  maxed = 0;
int  execflag = 0;
int  historylength = 0;
char cmd[256];
char *command = cmd; 
char history[MAXHISTLEN][256];
char historyItem[256];
char filename[64];
GtkWidget *combo; 


int  readHistory(void);
void writeHistory(char *history);
void usage (void);
void callback (GtkWidget * widget, gpointer data);
void keypress (GtkWidget * widget, GdkEventKey * event, gpointer data);
gint delete_event (GtkWidget * widget, GdkEvent * event, gpointer data);
int  runwin ();


/********************************
 *           Main Program       *
 ********************************/
int
main (int argc, char *argv[])
{
  int xfd;
  int buttonStatus = -1;
  int i;
  fd_set rfds;
  XEvent Event;

  gtk_init (&argc, &argv);

  strncat(filename, getenv("HOME"), 48);
  strncat(filename, "/.bbrun_history", 16);

  for (i = 1; i < argc; i++)
    {
      char *arg = argv[i];

      if (*arg == '-')
        {
          switch (arg[1])
            {
            case 'h':
	      usage();
	      exit (0);
	      break;
            case 'w':
	      historylength = readHistory();
	      runwin ();
	      if (execflag != 0) {
	        strncat(command, " &", 3);
		system (command);
	      }
	      exit(0);
              break;
            case 'v':
	      printf ("Version: %s\n", VERSION);
	      exit (0);
	      break;
            }
        }
    }

  createXBMfromXPM (wminet_mask_bits, bbrun, wminet_mask_width,
                    wminet_mask_height);
  openXwindow (argc, argv, bbrun, wminet_mask_bits, wminet_mask_width,
               wminet_mask_height);

  AddMouseRegion (0, 0, 0, 16, 16);   /* whole area */
  xfd = ConnectionNumber (display);
  
  while (1)
    {
      RedrawWindow ();
 
      FD_ZERO (&rfds);
      FD_SET (xfd, &rfds);
      select (xfd + 1, &rfds, NULL, NULL, NULL);
      
      /* X Events */
      while (XPending (display))
        {
          XNextEvent (display, &Event);
          switch (Event.type)
            {
            case Expose:
              RedrawWindow ();
              break;
            case DestroyNotify:
              XCloseDisplay (display);
              exit (0);
              break;
            case ButtonPress:
              i = CheckMouseRegion (Event.xbutton.x, Event.xbutton.y);
              buttonStatus = i;
              if (buttonStatus == i && buttonStatus >= 0)
                {
                  switch (buttonStatus)
                    {
                    case 0:
                      break;
                    }
                }

              break;
            case ButtonRelease:
              i = CheckMouseRegion (Event.xbutton.x, Event.xbutton.y);

              if (buttonStatus == i && buttonStatus >= 0)
                {
                  switch (buttonStatus)
                    {
                    case 0:
	      	      historylength = readHistory();
                      runwin ();
		      if (execflag != 0) {
	        	strncat(command, " &", 3);
			system (command);
		      }
                      break;
                    }
                }
              buttonStatus = -1;
              RedrawWindow ();
              break;
            }
        }
    }


  return 0;
}




int  readHistory(void)
{
    int n = 0;
    char buf[256];
    char *ptr;
    FILE *fp;

    if( (fp = fopen(filename, "r")) == 0 )
    {
        printf("History file does not exit : %s\n", filename);
          printf("Creating new history file.\n");
        if((fp = fopen(filename,"w")) == 0)
	{
            printf("Error creating new history file\n");
            return -1;
        }
        fclose(fp);
        return -1;
    }

    while(fgets(buf, 256, fp) != 0)
    {
	ptr = strtok(buf, "\n");
	if (ptr != NULL)
	{
          strncpy(history[n], ptr, 256);
          n++;
	}
	
	// scott@furt.com
	// This is a NULL line, which should NEVER happen.
	// Stop any further processing, becuase chances are very good
	// that the rest of the file is corrupt too.
	else {
		break;
	}

	// Dont process more than MAXHISTLEN lines
	if (n >= MAXHISTLEN) 
	{
  	  maxed = 1;
	  break;
	}
    }
    fclose(fp);

    return n;
}




void writeHistory(char *historyItem)
{
    int MAXCHARS = 256;
    int dup = 0;
    // c is not used in writeHistory anymore.
    //int c = 0;
    char buf[MAXCHARS];
    char *ptr;
    FILE *fp;
    // scott@furt.com
    // hist is an array of MAXHISTLEN lines
    char hist[MAXHISTLEN][MAXCHARS];
    // for reading file in
    int i = 0;
    // for writing file back
    int n = 0;

    fp = fopen(filename, "r");

    while( fgets(buf, MAXCHARS, fp) != 0)
    {
	ptr = strtok(buf, "\n");
	// scott@furt.com
	// Check for NULL ptr, to help fix a segfault bug when a blank
	// line got into ~/.bbrun_history and made ptr==NULL
	if (ptr != NULL) 
	{
		// this is a duplicate command
        	if (strcmp(historyItem, ptr) == 0)
 		{
  		  dup = 1;
  		}
		// not duplicate, store it in the hist[] array
		else {
		  strncpy(hist[i++], ptr, MAXCHARS);
		}

		// dont read more than MAXHISTLEN lines.
		if (i == MAXHISTLEN) {
			break;
		}
	}
	else {
		break;
	}
    }
    fclose(fp);
   
    // scott@furt.com
    //
    // Here's where i reworked history file writing to be
    // (IMO) less prone to corruption and errors and baddies.
    // 
    // History file has most recent commands last in the file,
    // and most ancient commands first.  Duplicate commands are
    // moved to be first in the file.  This is exactly the same
    // functionality that the original authour intended.
 
    // Open up the history file for writing
    // "w" mode will blank the original, which is intentional,
    // i want to write a fresh history file each time, rather
    // than edit the current one.
    if ((fp = fopen(filename, "w")) == 0) 
    {
	    printf("Cannot open %s for writing!", filename);
	    exit(0);
    }

    // If this is a duplicate command, write it at the beginning of the file.
    if (dup == 1) 
    {
	    fprintf(fp, "%s\n", historyItem);
    }

    // Dont write the most ancient command if history file is maxed
    // and there is are duplicates.  (so that the history file never
    // exceeds MAXHISTLEN lines)
    if (!dup && maxed) {
	n = 1;
    }
    
    // Write the history file.
    for (; n < i; n++) 
    {
	    fprintf(fp, "%s\n", hist[n]);
    }

    // Now, if it's not a duplicate, write the current command
    // at the end of the file.
    if (dup == 0) 
    {
        fprintf(fp, "%s\n", historyItem);
    }
    
    fclose(fp);
    
    // Below is the original writeHistory() code:    
    /* 
    // Remove first (oldest) item and append the most recent one.
    if (maxed == 1 && dup == 0) 
    {
      fp = fopen(filename,"r+");
      for (c = 0; c < MAXHISTLEN; c++) 
      {
        if (c != 0)
          fprintf(fp,"%s\n", history[c]);
      }
      fprintf(fp,"%s\n", historyItem);
      fclose(fp);
    }

    // Move the duplicate item from list and make it most recent.
    if (dup == 1) 
    {
      fp = fopen(filename,"r+");
      for (c = 0; c < historylength; c++) 
      {
        if (strcmp(historyItem, history[c]) != 0)
          fprintf(fp,"%s\n", history[c]);
      }
      fprintf(fp,"%s\n", historyItem);
      fclose(fp);
    }

    // Add item to end of the list.
    if (dup == 0 && maxed == 0) 
    {
      fp = fopen(filename,"a");
      fprintf(fp,"%s\n", historyItem);
      fclose(fp);
    }
  */
    
}


void usage (void)
{
  fprintf (stderr, "\nbbrun - Josh King <jking@dwave.net>\n\n");

  fprintf (stderr, "usage: ./bbrun [OPTIONS]\n");
  fprintf (stderr, "\n");
  fprintf (stderr, "Options:\n");
  fprintf (stderr, "\n");
  fprintf (stderr, "    -h    this help screen\n");
  fprintf (stderr, "    -w    withdrawn mode, will go straight to gtk entry box\n");
  fprintf (stderr, "    -v    print the version number\n");
  fprintf (stderr, "\n");

  exit (0);
}




// Event handler for ok and cancel buttons 
void callback (GtkWidget * widget, gpointer data)
{
  if ((char *) data == "ok")
    {
      strcpy (command, gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(combo)->entry)));
      if (command[0] == NULL)		// OK button was pressed but no command was typed in 
      {
        execflag = 0;
        gtk_main_quit ();
      }
      else
      {

        execflag = 1;
        writeHistory(command);
        gtk_main_quit ();
      }
    }

  if ((char *) data == "cancel")
    {

      execflag = 0;
      gtk_main_quit ();
    }
}


// Event handler for Enter and Escape keys 
void keypress (GtkWidget * widget, GdkEventKey * event, gpointer data)
{
  if (event->keyval == GDK_Return) 
  {
    strcpy (command, gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(combo)->entry)));
    if (command[0] == NULL)		// Enter was pressed but no command was typed in 
    {
      execflag = 0;
      gtk_main_quit ();
      gtk_object_destroy (GTK_OBJECT (widget)); 
    }
    else
    {
      execflag = 1;
      writeHistory(command);
      gtk_main_quit ();
      gtk_object_destroy (GTK_OBJECT (widget)); 
    }
  }
  else if (event->keyval == GDK_Escape) 
  {
    execflag = 0;
    gtk_main_quit ();
    gtk_object_destroy (GTK_OBJECT (widget)); 
  }
}


/* another callback */
gint delete_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  gtk_main_quit ();
  return (FALSE);
}


int runwin ()
{
  GtkWidget *window;
  GtkWidget *button;
  GtkWidget *table;
  GList *combo_items = NULL;
  int c = 0;


  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Run");


  // Here we just set a handler for delete_event that immediately * exits GTK.
  gtk_signal_connect (GTK_OBJECT (window), "delete_event", GTK_SIGNAL_FUNC (delete_event), NULL);

  // Handle the enter and escape keys.
  gtk_signal_connect(GTK_OBJECT(window), "key-press-event", GTK_SIGNAL_FUNC(keypress), GTK_OBJECT (window));


  gtk_container_set_border_width (GTK_CONTAINER (window), 10);	// Sets the border width of the window
  table = gtk_table_new (10, 2, FALSE);				// Create a 2x2 table
  gtk_container_add (GTK_CONTAINER (window), table);		// Put the table in the main window


  // Create a text entry area with drop down history list 
  combo = gtk_combo_new ();
  gtk_widget_set_usize( combo, 300, 30);
  gtk_combo_set_use_arrows_always(GTK_COMBO(combo), TRUE);	// scroll through the list with the arrow keys.
  gtk_window_set_focus(GTK_WINDOW (window), GTK_COMBO(combo)->entry); // focus the entry area so we can type right away.
  gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combo)->entry), "activate", GTK_SIGNAL_FUNC (callback), NULL);
  gtk_table_attach_defaults (GTK_TABLE(table), combo, 0, 10, 0, 1);
  gtk_widget_show (combo);


  // Instead of appending the items in reverse order, we prepend each item.  
  // This fixes a problem with the arrow keys cycling through the list, 
  // You would only be able to go up the list from oldest item to newest.
  for (c = 0; c < historylength; c++)
  {
    combo_items = g_list_prepend (combo_items, history[c]);
  }
  combo_items = g_list_prepend (combo_items, "");

  gtk_combo_set_popdown_strings (GTK_COMBO (combo), combo_items);
  g_list_free (combo_items);


  // Create the cancel button
  button = gtk_button_new_with_label ("Cancel");
  gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (callback), (gpointer) "cancel");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));
  gtk_table_attach_defaults (GTK_TABLE(table), button, 6, 8, 1, 2);
  gtk_widget_show (button);


  // Create the ok button
  button = gtk_button_new_with_label ("OK");
  gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (callback), (gpointer) "ok");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));
  gtk_table_attach_defaults (GTK_TABLE(table), button, 8, 10, 1, 2);
  gtk_widget_show (button);

  gtk_widget_show (table);
  gtk_widget_show (window);

  /* Rest in gtk_main and wait for the fun to begin! */
  gtk_main ();

  return (0);
}
