#include <map>
#include <string>

typedef std::map<std::string,unsigned int> KeywordMap;

struct TokenBlock {
  unsigned int tag;
  std::string name, data;
  unsigned long lineno;
};

bool defaultTokenError(const std::string& filename, const std::string& msg,
                       unsigned long lineno);

class MenuTokenizer {
public:
  typedef bool (*TokenError)(const std::string&, const std::string&,
			     unsigned long);
  MenuTokenizer(const KeywordMap& keys, const char* filename,
		TokenError errhandler = defaultTokenError);
  ~MenuTokenizer(void);
  bool next(TokenBlock& block);

private:
  std::ifstream file;
  std::string filename;
  const KeywordMap& keywords;
  TokenError error;
  unsigned long lineno;
};
