#ifndef ELF 
#define ELF 1
#define EI_NIDENT 16
typedef unsigned char uchar; // 1 byte
typedef unsigned short Elf64_Half; //2 bytes
typedef unsigned int Elf64_Word; //4 bytes
typedef unsigned long Elf64_Addr; //8 bytes
typedef unsigned long Elf64_Off; //8 bytes


typedef struct Elf64_Ehdr
{
        uchar e_ident[EI_NIDENT];
        Elf64_Half      e_type;
        Elf64_Half      e_machine;
        Elf64_Word      e_version;
        Elf64_Addr     e_entry;
        Elf64_Off      e_phoff;
        Elf64_Off      e_shoff;
        Elf64_Word     e_flags;
        Elf64_Half     e_ehsize;
        Elf64_Half      e_phentsize;
        Elf64_Half      e_phnum;
        Elf64_Half      e_shentsize;
        Elf64_Half       e_shnum;
        Elf64_Half      e_shstrndx;
} Elf64_Ehdr ;


void print_e_ident(Elf64_Ehdr * e);
#define SHN_UNDEF 0
#define ET_NONE 0
#define ET_REL 1
#define ET_EXEC 2
#define ET_DYN 3
#define ET_CORE 4
#define ET_LOPROC 5
#define ET_HIPROC 6
#define EM_NONE 0
#define EM_M32 1
#define EM_SPARC 2
#define EM_386 3
#define EM_68K 4
#define EM_88K 5
#define EM_860 7
#define EM_MIPS 8
#define EM_S370 9
#define EM_ARM  40
#define EM_IA_64 50     
#define EV_NONE 0
#define EV_CURRENT 1
#define EF_MIPS_NOREORDER 1
#define EF_MIPS_PIC 2
#define EF_MIPS_CPIC 4
#define EF_MIPS_UCODE 16
#define EF_MIPS_ABI2 32
#define EF_MIPS_OPTION_FIRST 128
#define EF_MIPS_ARCH_ASE 251658240
#define EF_MIPS_ARCH_ASE_MDMX 134217728
#define EF_MIPS_ARCH_ASE_M16 67108864
#define EF_MIPS_ARCH 251658240

typedef struct Elf64_Phdr
{
        Elf64_Word p_type;
        Elf64_Off p_offset;
        Elf64_Addr p_vaddr;
        Elf64_Addr p_paddr;
        Elf64_Word p_filesz;
        Elf64_Word p_memsz;
        Elf64_Word p_flags;
        Elf64_Word p_align;
}Elf64_Phdr;

#define PT_NULL 0
#define PT_LOAD 1
#define PT_DYNAMIC 2
#define PT_INTERP 3
#define PT_NOTE 4
#define PT_SHLIB 5
#define PT_PHDR 6
#define PT_TLS          7               /* Thread-local storage segment */
#define PT_NUM          8               /* Number of defined types */
#define PT_LOOS 0x60000000
#define PT_GNU_EH_FRAME 0x6474e550      /* GCC .eh_frame_hdr segment */
#define PT_GNU_STACK    0x6474e551      /* Indicates stack executability */
#define PT_GNU_RELRO    0x6474e552      /* Read-only after relocation */
#define PT_SUNWBSS      0x6ffffffa      /* Sun Specific segment */
#define PT_SUNWSTACK    0x6ffffffb      /* Stack segment */
#define PT_HISUNW       0x6fffffff
#define PT_HIOS 0x6fffffff
#define PT_LOPROC 0x70000000
#define PT_HIPROC 0x7fffffff


typedef struct Note
{
        unsigned int namesz;
        unsigned int descsz;
        unsigned int type;
        char nameAndDesc[1];
}Note;
typedef struct Elf64_Shdr
{
        Elf64_Word sh_name;
        Elf64_Word sh_type;
        Elf64_Word sh_flags;
        Elf64_Addr sh_addr;
        Elf64_Off sh_offset;
        Elf64_Word sh_size;
        Elf64_Word sh_link;
        Elf64_Word sh_info;
        Elf64_Word sh_addralign;
        Elf64_Word sh_entsize;
}Elf64_Shdr;


int readElfFile(char * , char * , int , Elf64_Shdr *);


#define SHT_NULL 0
#define SHT_PROGBITS 1
#define SHT_SYMTAB 2
#define SHT_STRTAB 3
#define SHT_RELA 4
#define SHT_HASH 5
#define SHT_DYNAMIC 6
#define SHT_NOTE 7
#define SHT_NOBITS 8
#define SHT_REL 9 
#define SHT_SHLIB 10
#define SHT_DYNSYM 11
#define SHT_LOPROC 0x70000000
#define SHT_HIPROC 0x7fffffff
#define SHT_LOUSER 0x80000000
#define SHT_HIUSER 0x8fffffff


#define SHF_WRITE 1
#define SHF_ALLOC 2
#define SHF_EXECINSTR 4
#define SHF_MASKPROC 0xf0000000
#endif

